/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Polled Messaging Connection Object Source)
 *
 *****************************************************************************
 * FileName:        conn2.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains Polled messaging support for the Connection Object 
 * described in Section 5-4 and Chapter 7 of Volume 1 of the DeviceNet 
 * specification. Additional support is in the UsrConn.c file.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/


#ifndef	__CONN2_H__
#define	__CONN2_H__

/*********************************************************************
 * Connection related variables
 ********************************************************************/
extern CONN 	uConn2;


/*********************************************************************
 * Function:        unsigned char _Conn2Create(void)
 *
 * PreCondition:    The CAN (or other) driver must be prepared to 
 *					accept some filter settings.
 *
 * Input:       	none	
 *                  
 * Output:      	unsigned char handle to the connection	
 *
 * Side Effects:    none
 *
 * Overview:        This function creates a connection 
 *					in the predefined set and returns a 
 *					handle to the connection. The connection is 
 *					placed into a 'configuring' state. 
 *					
 *					This function will call out to the users code
 *					for additional resource allocation. If the 
 *					user returns NULL then the allocation will not
 *					occur.
 *
 * Note:            This function is not called directly by 
 *					application code.
 ********************************************************************/
unsigned char _Conn2Create(void);



/*********************************************************************
 * Function:        unsigned char _Conn2Close()
 *
 * PreCondition:    The connection should have already been open.
 *
 * Input:       	none
 *                  
 * Output:      	unsigned char instance that closed
 *
 * Side Effects:    none
 *
 * Overview:        Closes the specified connection. Users code is 
 *					notified to release any used resources.
 *
 * Note:            none
 ********************************************************************/
unsigned char _Conn2Close(void);


/*********************************************************************
 * Function:        void _Conn2TimerEvent(void)
 *
 * PreCondition:    None
 *
 * Input:       	None	
 *                  
 * Output:      	None
 *
 * Side Effects:    None
 *
 * Overview:        Update timer and process any timer events. If the 
 *					timer overflows then the state of the connection
 *					is changed.
 *
 * Note:            None
 ********************************************************************/
void _Conn2TimerEvent(void);


/*********************************************************************
 * Function:        void _Conn2RxEvent(void)
 *
 * PreCondition:    none
 *
 * Input:       	none
 *                  
 * Output:      	none
 *
 * Side Effects:    none
 *
 * Overview:        Process received data for this connection.
 *
 * Note:            This event occures when data has been received
 *					for this connection instance.
 ********************************************************************/
void _Conn2RxEvent(void);


/*********************************************************************
 * Function:        void _Conn2TxOpenEvent(void)
 *
 * PreCondition:    A transmit request must have been made.
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    none
 *
 * Overview:        Process open transmit que event
 *
 * Note:            This event occurs when the buffer is available 
 *					for this connection instance to transmit. A 
 *					transmit request must have been made to enter 
 *					this function.
 ********************************************************************/
void _Conn2TxOpenEvent(void);


/*********************************************************************
 * Function:        void _Conn2TxEvent(void)
 *
 * PreCondition:    Data must have been queued to transmit.
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    none
 *
 * Overview:        Process data for this connection.
 *
 * Note:            This event occurs when the buffer has successfully
 *					placed the requested data on the bus.
 ********************************************************************/
void _Conn2TxEvent(void);


/*********************************************************************
 * Function:        unsigned char _Conn2ExplicitEvent(void)
 *
 * PreCondition:    none
 *
 * Input:       	none	
 *                  
 * Output:      	unsigned char success of the request
 *
 * Side Effects:    none
 *
 * Overview:        Handle explicit messaging for this instance
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn2ExplicitEvent(void);


/*********************************************************************
 * Function:        unsigned char _Conn2GetAttrib()
 *
 * PreCondition:    none
 *
 * Input:       	none
 *                  
 * Output:      	none
 *
 * Side Effects:    none
 *
 * Overview:        Handle explicit messaging
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn2GetAttrib(void);


/*********************************************************************
 * Function:        unsigned char _Conn2SetAttrib(void)
 *
 * PreCondition:    none
 *
 * Input:       	none
 *                  
 * Output:      	unsigned char success of the request
 *
 * Side Effects:    none
 *
 * Overview:        Handle explicit messaging
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn2SetAttrib(void);


			   
#endif	/*__CONN2_H__*/
