;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI Slave        ;
;*  for PIC16/PIC18 family                                                      ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            SPISInt.inc                                     ;    
;* Dependencies:        P16xxx.inc                                      ;
;*                      P18xxx.inc                                      ;
;*                      SPISInt.Def                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Apr 25, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************************************;
                                                ;
 #ifndef __SPISInt_INC                          ;Check if inc file already included
                                                ;
        #define __SPISInt_INC                   ;
                                                ;
;***********************************************;
        #include "SPISInt.Def"                  ;
                                                ;
;***********************************************;
                                                ;
    #ifndef SPISInt_Source                      ;
                                                ;
        #define     BSSP_MODULE                 ;Module definition
                                                ;
        #include    "P18xxx.inc"                ;
        #include    "P16xxx.inc"                ;
;***********************************************;
                                                ;
        EXTERN      vSPISIntStatus              ;
                                                ;
        EXTERN      SPISIntInit                 ;
        EXTERN      SPISIntISR                  ;
                                                ;
        #if SPIS_TX_BUF_LENGTH != 0             ;
                                                ;
        EXTERN      vSPISIntTxBuffer            ;
                                                ;
        #if SPIS_TX_BUF_LENGTH != 1             ;
                                                ;
        EXTERN      _SPISIntWrTxBuf             ;
                                                ;
        #endif                                  ;
        #endif                                  ;
                                                ;
        #if SPIS_RX_BUF_LENGTH != 0             ;
                                                ;
        EXTERN      vSPISIntRxBuffer            ;
        EXTERN      SPISIntDiscardRxBuf         ;
                                                ;
        #if SPIS_RX_BUF_LENGTH != 1             ;
                                                ;
        EXTERN      _SPISIntRdRxBuf             ;
                                                ;
        #endif                                  ;
        #endif                                  ;
                                                ;
;***********************************************;
                                                ;
    #else                                       ;
                                                ;
        GLOBAL      vSPISIntStatus              ;
                                                ;
        #if SPIS_TX_BUF_LENGTH != 0             ;
                                                ;
        GLOBAL      vSPISIntTxBuffer            ;
                                                ;
        #endif                                  ;
                                                ;
        #if SPIS_RX_BUF_LENGTH != 0             ;
                                                ;
        GLOBAL      vSPISIntRxBuffer            ;
                                                ;
        #endif                                  ;
                                                ;
    #endif                                      ;
;***********************************************;

;***********************************************;
;SPISIntStatus register bits                    ;
;***********************************************;
                                                ;
SPISSave            EQU     5                   ;Enable trasmission
SPISRxBufOverFlow   EQU     4                   ;Receive Buffer is Over flowing
SPISRxBufFull       EQU     3                   ;Receive Buffer is Full
SPISRxBufEmpty      EQU     2                   ;Receive Buffer is Empty
SPISTxBufFull       EQU     1                   ;Transmit Buffer is Full
SPISTxBufEmpty      EQU     0                   ;Transmit Buffer isEmpty
                                                ;
;***********************************************;

;***********************************************;
                                                ;
Hi              EQU     1                       ;
Lo              EQU     0                       ;
ActiveToIdle    EQU     1                       ;
IdleToActive    EQU     0                       ;
Mids            EQU     0                       ;
Ends            EQU     1                       ;
                                                ;
;***********************************************;
;***********************************************;


    #ifdef  _PIC16xxx

;***********************************************************************;
; Macro: mSPISSetClockIdleState                                         ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This sets Idle State of the Clock pin High('Hi') or Low('Lo')   ;
;                                                                       ;
; Input: State - 'Hi'(High) or 'Lo'(Low)                                ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntSetClockIdleState macro State           ;
                                                ;
    #if State == Lo                             ;
                                                ;
        BANKSEL SSPCON                          ;
        bcf     SSPCON,CKP                      ;
                                                ;
    #else                                       ;
                                                ;
        BANKSEL SSPCON                          ;
        bsf     SSPCON,CKP                      ;
                                                ;
    #endif                                      ;
        ENDM                                    ;
                                                ;
;***********************************************;    



;***********************************************************************;
; Macro: mSPISSetTransmitOnClockEdge                                    ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This selects to Transmit at Clock Edge 'IdleToActive' or        ;
;       'ActiveToIdle'                                                  ;
;                                                                       ;
; Input: Edge - 'IdleToActive' or 'ActiveToIdle'                        ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntSetTransmitOnClockEdge macro Edge       ;
                                                ;
    #ifndef _MSSP_MODULE                        ;
                                                ;
     #ifndef _SSP_MODULE                        ;
                                                ;
        #ifdef  _BSSP_MODULE                    ;
                                                ;
        messg "Its not allowed to select Tranmission Edge in this processor."
        messg "Its always at IdleToActive edge of clock."
                                                ;
        #endif                                  ;
                                                ;
     #else                                      ;
                                                ;
      #if Edge == IdleToActive                  ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bcf     SSPSTAT,CKE                     ;
                                                ;
      #else                                     ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bsf     SSPSTAT,CKE                     ;
                                                ;
      #endif                                    ;
     #endif                                     ;
                                                ;
    #else                                       ;
                                                ;
      #if Edge == IdleToActive                  ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bcf     SSPSTAT,CKE                     ;
                                                ;
      #else                                     ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bsf     SSPSTAT,CKE                     ;
                                                ;
      #endif                                    ;
                                                ;
    #endif                                      ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;    



;***********************************************************************;
; Macro: mSPISIntDisable                                                ;
;                                                                       ;
; PreCondition: Communication should be over                            ;
;                                                                       ;
; Overview:                                                             ;
;       This disables MSSP Module.                                      ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntDisable MACRO                           ;
                                                ;
        BANKSEL SSPCON                          ;
        bcf     SSPCON,SSPEN                    ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;



    #if SPIS_TX_BUF_LENGTH != 0

;***********************************************************************;
; Macro: mSPISIntPut                                                    ;
;                                                                       ;
; PreCondition: SPISIntStart should have called.                        ;
;                                                                       ;
; Overview:                                                             ;
;       This writes data into buffer.                                   ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntPut macro                               ;
                                                ;
        #if SPIS_TX_BUF_LENGTH == 1             ;
                                                ;
        movwf   vSPISIntTxBuffer                ;
        bsf     vSPISIntStatus,SPISTxBufFull    ;
        bcf     vSPISIntStatus,SPISTxBufEmpty   ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL PIE1                            ;
        bcf     PIE1,SSPIE                      ;
                                                ;
        PAGESEL _SPISIntWrTxBuf                 ;
        call    _SPISIntWrTxBuf                 ;
                                                ;
        BANKSEL PIE1                            ;
        bsf     PIE1,SSPIE                      ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;

    #endif                                      ;




    #if SPIS_RX_BUF_LENGTH != 0

;***********************************************************************;
; Macro: mSPISIntGet                                                    ;
;                                                                       ;
; PreCondition: SPISIntInit should have called and                      ;
;               vSPISIntStatus<SPISRxBufEmpty> should be '0'.           ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntGet macro                               ;
                                                ;
        #if SPIS_RX_BUF_LENGTH == 1             ;
                                                ;
        movf    vSPISIntRxBuffer,W              ;If buffer length is one directly
        bcf     vSPISIntStatus,SPISRxBufFull    ;buffer is read to w and flags are changed.
        bsf     vSPISIntStatus,SPISRxBufEmpty   ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL PIE1                            ;
        bcf     PIE1,SSPIE                      ;
                                                ;
        PAGESEL _SPISIntRdRxBuf                 ;
        call    _SPISIntRdRxBuf                 ;
                                                ;
        BANKSEL PIE1                            ;
        bsf     PIE1,SSPIE                      ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;

    #endif                                      ;

    #endif



;***********************************************************************;
; Macro: mSPISIntSaveReceivedByte                                       ;
;                                                                       ;
; PreCondition: SPIS_RX_BUF_LENGTH should be non-zero                   ;
;                                                                       ;
; Overview:                                                             ;
;       This sets a flag 'SPISSave' to indicate that the byte received  ;
;       should be saved                                                 ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: SPISIntStatus                                                 ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntSaveReceivedByte macro                  ;
                                                ;
        bsf     SPISIntStatus,SPISSave          ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;


;***********************************************************************;
; Macro: mSPISIntDiscardReceivedByte                                    ;
;                                                                       ;
; PreCondition: SPIS_RX_BUF_LENGTH should be non-zero                   ;
;                                                                       ;
; Overview:                                                             ;
;       This clears the flag 'SPISSave' to indicate that the byte       ;
;       received  should not be saved                                   ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: SPISIntStatus                                                 ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntDiscardReceivedByte macro               ;
                                                ;
        bcf     SPISIntStatus,SPISSave          ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;




    #ifdef  _PIC18xxx


;***********************************************************************;
; Macro: mSPISIntSetClockIdleState                                      ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This sets Idle State of the Clock pin High('Hi') or Low('Lo')   ;
;                                                                       ;
; Input: State - 'Hi'(High) or 'Lo'(Low)                                ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntSetClockIdleState macro State           ;
                                                ;
    #if State == Lo                             ;
                                                ;
        bcf     SSPCON1,CKP                     ;
                                                ;
    #else                                       ;
                                                ;
        bsf     SSPCON1,CKP                     ;
                                                ;
    #endif                                      ;
        ENDM                                    ;
                                                ;
;***********************************************;    


;***********************************************************************;
; Macro: mSPISIntSetTransmitOnClockEdge                                 ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This selects to Transmit at Clock Edge 'IdleToActive' or        ;
;       'ActiveToIdle'                                                  ;
;                                                                       ;
; Input: Edge - 'IdleToActive' or 'ActiveToIdle'                        ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntSetTransmitOnClockEdge macro Edge       ;
                                                ;
    #if Edge == IdleToActive                    ;
                                                ;
        bcf     SSPSTAT,CKE                     ;
                                                ;
    #else                                       ;
                                                ;
        bsf     SSPSTAT,CKE                     ;
                                                ;
    #endif                                      ;
        ENDM                                    ;
                                                ;
;***********************************************;


;***********************************************************************;
; Macro: mSPISIntDisable                                                ;
;                                                                       ;
; PreCondition: Communication should be over                            ;
;                                                                       ;
; Overview:                                                             ;
;       This disables SSP Module.                                       ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntDisable MACRO                           ;
                                                ;
        bcf     SSPCON1,SSPEN                   ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;



    #if SPIS_TX_BUF_LENGTH != 0

;***********************************************************************;
; Macro: mSPISIntPut                                                    ;
;                                                                       ;
; PreCondition: SPISIntStart should have called.                        ;
;                                                                       ;
; Overview:                                                             ;
;       This writes data into buffer.                                   ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntPut macro                               ;
                                                ;
        #if SPIS_TX_BUF_LENGTH == 1             ;
                                                ;
        movwf   vSPISIntTxBuffer                ;
        bsf     vSPISIntStatus,SPISTxBufFull    ;
        bcf     vSPISIntStatus,SPISTxBufEmpty   ;
                                                ;
        #else                                   ;
                                                ;
        bcf     PIE1,SSPIE                      ;
                                                ;
        call    _SPISIntWrTxBuf                 ;
                                                ;
        bsf     PIE1,SSPIE                      ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;

    #endif                                      ;




    #if SPIS_RX_BUF_LENGTH != 0

;***********************************************************************;
; Macro: mSPISIntGet                                                    ;
;                                                                       ;
; PreCondition: SPISIntInit should have called and                      ;
;               vSPISIntStatus<SPISRxBufEmpty> should be '0'.           ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPISIntGet macro                               ;
                                                ;
        #if SPIS_RX_BUF_LENGTH == 1             ;
                                                ;
        movf    vSPISIntRxBuffer,W              ;If buffer length is one directly
        bcf     vSPISIntStatus,SPISRxBufFull    ;buffer is read to w and flags are changed.
        bsf     vSPISIntStatus,SPISRxBufEmpty   ;
                                                ;
        #else                                   ;
                                                ;
        bcf     PIE1,SSPIE                      ;
                                                ;
        call    _SPISIntRdRxBuf                 ;
                                                ;
        bsf     PIE1,SSPIE                      ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;

    #endif                                      ;




;***********************************************************************;
; Macro:        mSetSPISIntHighPriority                                 ;
;                                                                       ;
; Overview:     Sets high priority for SSP interrupt.                   ;
;                                                                       ;
; Input:        None                                                    ;
;                                                                       ;
; Output:       None                                                    ;
;                                                                       ;
; Side Effects: None                                                    ;
;***********************************************************************;
                                                ;
mSetSPISIntHighPriority MACRO                   ;
                                                ;
    bsf    IPR1,SSPIP                           ;High Priority for MSSP Int.
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;



;***********************************************************************;
; Macro:        mSetSPISIntLowPriority                                  ;
;                                                                       ;
; Overview:     Sets low priority for SSP interrupt.                    ;
;                                                                       ;
; Input:        None                                                    ;
;                                                                       ;
; Output:       None                                                    ;
;                                                                       ;
; Side Effects: None                                                    ;
;***********************************************************************;
                                                ;
mSetSPISIntLowPriority  MACRO                   ;
                                                ;
    bcf    IPR1,SSPIP                           ;Low Priority for MSSP Int.
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;

        #endif

 #endif



;***********************************************;
;        END                                    ;
;***********************************************;
