#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"



int
getscreen( fp, s )

	FILE 		*fp;
	Screen		*s;
{
	static char 	*funcname = "Getscreen";
	Screenlist      *ts;
	Screen		*t;
	Lkup_union      lkp, *lkup = &lkp;
	int 		got_name = NO;
	int 		n;
	char 		*colon, *p1;
	char 		tname[Nchars],tval[Nchars];
	char 		ln[Nchars], *line = ln;
	char 		*rindex();


  s->x_key = s->y_key = -1;  /* initialize these indexes to -1 */

  while((line = get_data_line(fp)) != NULL)
  {
	if(line[0] == '(' ){
		if(Supressed(MSK_SCREEN))
		{
			Unsupress(MSK_SCREEN);
		 }
		else
		{
		    if((t = (Screen *)calloc(1,sizeof(Screen)))==NULL){
	      		printf("%s: Can't allocate screen\n",funcname);
	      		return (NULL);
	 	     }
		    if(s) s->next = t;
		    t->prev = s;
		    s = t;
		    s->x_key = s->y_key = -1;  /* initialize to -1 */
		 }


      		p1 = line + 1;
      		if((p1 = parse(Str,s->name,p1)) == NULL)
					screen_error(s,"name",lkup);
      		if((p1 = parse(Str,lkup->name,p1)) == NULL) 
					screen_error(s,"type",lkup);
      		if((s->type = (int)lookup_type(Key, lkup)) == FAILURE)
		{
          		printf("%s: Bad screen type `%s' in line %d\n",
	     			funcname,lkup->name,linecount);
	 	 }
		if((p1 = parse(Str,s->parentname,p1)) == NULL) 
					screen_error(s,"parent",lkup);
		if((p1 = parse(Num,&s->x,p1)) == NULL) 
					screen_error(s,"x",lkup);
		if((p1 = parse(Num,&s->y,p1)) == NULL) 
					screen_error(s,"y",lkup);
		if((p1 = parse(Num,&s->width,p1)) == NULL) 
					screen_error(s,"width",lkup);
		if((p1 = parse(Num,&s->height,p1)) == NULL) 
					screen_error(s,"height",lkup);
		if((p1 = parse(Num,&s->borderwidth,p1)) == NULL) 
					screen_error(s,"borderwidth",lkup);
		if((p1 = parse(Num,&s->border,p1)) == NULL) 
					screen_error(s,"border",lkup);
		s->border_pixmap = XMakeTile(s->border);
		if((p1 = parse(Num,&s->background,p1)) == NULL)
					screen_error(s,"background",lkup);
		s->background_pixmap = XMakeTile(s->background);
Debug((stderr,"p1 remaining `%s'\n",p1));
		if(strlen(p1) && !(p1[0] == '\n'))
		{
			if((p1 = parse(Num,&s->x_key,p1)) == NULL) 
					screen_error(s,"x_key",lkup);
Debug((stderr,"x_key `%d'\n",s->x_key));
		 }
		if(strlen(p1) && !(p1[0] == '\n'))
		{
			if((p1 = parse(Num,&s->y_key,p1)) == NULL) 
					screen_error(s,"y_key",lkup);
Debug((stderr,"x_key `%d'\n",s->y_key));
		 }
		got_name = YES;
	 }    

    else
    {


    sscanf(line,"%s %s\n",tname,tval);
    if( (colon = rindex(tname,':')) !=0 ){
      		*colon = '\0';
     }

    if((n=lookup(tname)) != NULL){

	if(n <= Primary_Keys)
	{
	  if(got_name == NO)
	  {
	    	printf("%s: Name missing in screen above line %d\n"
			,funcname,linecount);
		exit(1);
           }
	  return(n);
	 }

      switch(n){

      case NAME:
		strcpy(s->name, tval);
		got_name = YES;
		break;
      case TYPE:
		strcpy(lkup->name,tval);
		if((s->type = (int)lookup_type(Key, lkup)) == FAILURE){
	  		printf("%s: Bad screen type '%s' in line %d\n",
		 		funcname,tval,linecount);
	 	 }
		break;
      case PARENT:
		strcpy(s->parentname, tval);
		break;
      case XPOS:
		s->x = atoi(tval);
		break;
      case YPOS:
		s->y = atoi(tval);
		break;
      case WIDTH:
		s->width = atoi(tval);
		break;
      case HEIGHT:
		s->height = atoi(tval);
		break;
      case BORDERWIDTH:
		s->borderwidth = atoi(tval);
		break;
      case BORDER:
		s->border = atoi(tval);
		s->border_pixmap = XMakeTile(s->border);
		break;
      case BACKGROUND:
		s->background = atoi(tval);
		s->background_pixmap = XMakeTile(s->background);
		break;
      case X_KEY:
		s->x_key = atoi(tval);
		break;
      case Y_KEY:
		s->y_key = atoi(tval);
		break;
      default:
		printf("%s: can't use `%s', line %d\n"
		       ,funcname,tname,linecount);
     }
      tval[0] = NULL;
    }
    else
    {
	 printf("%s: can't use `%s', line %d\n",funcname,tname,linecount); 
     }
  }
}
 
  return(-1);

}

