/*
 * Assumes <X/Xlib.h> has already been included
 */

typedef struct _Box {
	short	x, y;
	short	w, h;
} Box;

typedef struct _CVideo {
	Window		window;			/* The Video Window */
	int		width, height;		/* Size of video window */
	Box		shown;			/* The part we can see */
	Box		rband;			/* Rubber-band box */
	int		disc;			/* VDP's file descriptor */
	unsigned short	startframe;		/* The starting frame */
	short		rows, columns;		/* Layout of the matrix */
	short		offset;			/* Every how may frames? */
	float		xoverlap, yoverlap;	/* Fraction to trim edges */
	short		orientation;		/* VERTICAL or HORIZONTAL */
	short		function;		/* What are we doing now? */
	Window		kludge;
	Window		hack;
} CVideo;

#define	HORIZONTAL	0
#define VERTICAL	1

CVideo	*InitCVideo();
void	CVideoProcess();
