/*    getTKscroll.c   						*/

#include <stdio.h>
#include <X/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#include "widgets.h"

   TKscrollbar  ScrollDefaults = {
  		0,
		(Window) NULL, (Window) NULL,
		"value", "horizontal",
		0,0,20,10,1,
		1,0,1,
		0,0,0,
		"name",
		"RootWindow",
		(void (*)()) NULL,
		(void (*)()) NULL,
		1.0, 1.0
	 };


int
getTKscroll( fp, m )

	FILE 		*fp;
	Map		*m;
{
  static char 	*funcname = "getTKscrollbar";
  Lkup_union 	lkp, *lkup = &lkp;
  TKscrollbar	*s;
  int 		i, n;
  char 		*p1, *p2, *colon;
  char 		ln[Nchars], *line = ln;
  char		tname[Nchars],tval[Nchars];
  char 		*rindex(), *index();


  if((s = (TKscrollbar *)calloc(1,sizeof(TKscrollbar)))==NULL){
	      		printf("%s: Can't allocate scrollbar\n",funcname);
	      		return (NULL);
	 	     }

  bcopy( &ScrollDefaults, s, sizeof(TKscrollbar) );

  m->simple.w = (Window) s;

while((line = get_data_line(fp)) != NULL)
{

  sscanf(line,"%s %[^\n]\n",tname,tval);
 	 if( (colon = rindex(tname,':')) !=0 )
	 {
    		*colon = '\0';
  	  }

  if((n=lookup(tname)) != NULL  && n <= Primary_Keys)
  {
      	printf("%s: `%s'\n",funcname,s->name);
      	s->border_pixmap = XMakeTile(s->border);
	s->foreground_pixmap = XMakeTile(s->foreground);
	s->background_pixmap = XMakeTile(s->background);
        return(n);
   }
   
   switch(n)
   {

    	case POS_IN:
      		i = 0;
		p1 = tval;
		while ((p2 = index(p1,',')) != 0)
		{
	  		*p2 = '\0';
			m->simple.pos[InPoint][i++] = atoi(p1);
			p1 = ++p2;
      		 }
		m->simple.pos[InPoint][i] = atoi(p1);
      		break;
    	case POS_OUT:
      		i = 0;
		p1 = tval;
		while ((p2 = index(p1,',')) != 0)
		{
	  		*p2 = '\0';
			m->simple.pos[OutPoint][i++] = atoi(p1);
			p1 = ++p2;
      		 }
		m->simple.pos[OutPoint][i] = atoi(p1);
      		break;

     }

  if((n=TK_lookup(tname)) != NULL)
  {
 
   switch(n)
   {

	case TK_NAME:
      		strcpy(s->name,tval);
      		break;
    	case TK_VALUE:
      		strcpy(s->value,tval);
      		break;
    	case TK_ORIENTATION:
      		strcpy(s->orientation,tval);
      		break;
    	case TK_BORDERWIDTH:
      		s->borderwidth = atoi(tval);
      		break;
    	case TK_FOREGROUND:
      		s->foreground = atoi(tval);
      		break;
    	case TK_BACKGROUND:
      		s->background = atoi(tval);
      		break; 
    	case TK_BORDER:
 		s->border = atoi(tval);
      		break; 
    	case TK_SCROLLUPDOWNPROC:
		strcpy(lkup->name,tval);
      		if((s->scrollupdownproc =
			 (void(*)()) lookup_function(Key, lkup)) == NULL)
		{
	  		printf("%s: bad function name `%s' in line %d\n",
			       	funcname, lkup->name, linecount);
		 } 
      		break; 
    	case TK_THUMBPROC:
		strcpy(lkup->name,tval);
      		if((s->thumbproc = 
			 (void(*)()) lookup_function(Key, lkup)) == NULL)
		{
	  		printf("%s: bad function name `%s' in line %d\n",
			       	funcname, lkup->name, linecount);
		 } 
      		break; 
    	case TK_WIDTH:
     		s->width = atoi (tval);
      		break;
    	case TK_HEIGHT:
      		s->height = atoi (tval);
           	break;
    	case TK_X:
      		s->x = atoi (tval);
      		break;
    	case TK_Y:
      		s->y = atoi (tval);
      		break;
    	case TK_TOP:
      		s->top = atof (tval);
      		break;
    	case TK_SHOWN:
      		s->shown = atof (tval);
      		break;

    	default:
      		printf("%s: can't use `%s', line %d\n"
			,funcname,tname,linecount);
      } 						/* switch 	*/
     tval[0] = NULL;
   } 							/* if TK_lookup */
  else
  {
	 printf("%s: can't use `%s', line %d\n",funcname,tname,linecount);
   }
}  							/* while	*/
 
printf("%s: `%s`\n",funcname,s->name);
return(-1);

}


