
#include <stdio.h>
#include "hash.h"
#include "clink.h"

#include <a.out.h>
#include <stab.h>

HashTablePtr
cprog_link( progname )
	char *progname;		/* usually, argv[0] */
{
FILE *	fp;
char	SymType = 0;	/* T, B, D */
HashNodePtr	np;
HashTablePtr	ht;
char *malloc();
struct exec e;
struct nlist sym;
int	nsyms;
long	tabtop;
long	strsize;
long	type;
int	i;
char *	strz;
char *	theStr;

	printf("reading in symbol table ... ");
	fflush(stdout);

	if( (ht = hash_create("global variables",256)) == NULL )
	{
		printf("hash_create failed\n");
		exit(1);
	}

	fp = fopen( progname, "r" );
	if( fp==NULL )
	{
		printf("cprog_link(): executable file %s not found\n",progname);
		return NULL;		
	}

	if( fread( &e, sizeof(struct exec), 1, fp ) != 1 )
	{
		printf("Bad exec read.\n");
		exit(-1);
	}
	if( N_BADMAG(e) )
	{
		printf("file '%s' has bad magic number\n",progname);
		exit(-1);
	}

	fseek( fp, N_STROFF(e), 0 );
	if( fread( &strsize, sizeof(strsize), 1, fp )!=1 )
	{
		printf("Bad strsize read\n");
		exit(-1);
	}

	strz = malloc( strsize );
	fseek( fp, N_STROFF(e), 0 );
	if( fread( strz, sizeof(*strz), strsize, fp ) != strsize )
	{
		printf("Bad strz read\n");
		exit(-1);
	}

	nsyms = e.a_syms / sizeof(sym);

	tabtop = (long)(N_SYMOFF(e));
	for( i=0; i<nsyms; i++ )
	{
		fseek(fp,tabtop+(i*sizeof(struct nlist)),0);
		if( fread(&sym, sizeof(sym), 1, fp ) != 1 )
			printf("Bad symbol read.\n");
		theStr = (char *)(strz + sym.n_un.n_strx);

		switch( sym.n_type )
		{
		case (N_TEXT | N_EXT):
			SymType = 'T';
			break;
		case (N_DATA | N_EXT):
			SymType = 'D';
			break;
		case (N_BSS | N_EXT):
			SymType = 'B';
			break;
		default:
			SymType = 0;
			break;
		}

		if( SymType )
		{
			np = hash_install(ht, theStr, NULL, SymType);
			if( np == NULL )
			{
				printf("hash_install() failed\n");
				exit(1);
			}
			else
				np->ptr = (char *) sym.n_value;
		}
		
	}

	fclose(fp);
	free( (char *) strz );

	printf("done.\n");
	return ht;
}

HashNodePtr
cprog_lookup( ht, name )

	HashTablePtr	ht;
	char *		name;
{
char	realname[128];

	realname[0] = '_';
	strcpy( (realname+1), name );
	return hash_lookup( ht, realname );
}
