
#include <stdio.h>
#include <X10/Xlib.h>
#include "ev_tokens.h"

int
dump_env( e )
	ENV_PTR	e;
{
VAR_PTR	vp;
CODE_PTR	cp;
OBJ_PTR		op;

	if( !e )
	{
		printf("<env is EMPTY>\n");
		return 0;
	}

	printf("environment %s\n",e->name);
	printf("{\n");
	printf("-- ============ C declarations =============\n");
	print_Cdecs();
	printf("\n");
	printf("-- ============ Global vars =============\n");
	printf("\n");
	for( vp = e->global_vars; vp; vp = vp->next )
		printf("\tvar %s;\n",vp->name);
	printf("\n");

	printf("-- ============ Global code segs =============\n");
	for( cp = e->global_code; cp; cp = cp->next )
		print_code( cp );
	printf("\n");

	printf("-- ============ Object list =============\n");
	printf("\n");

	for( op = e->objlist; op; op = op->next )
	{
		printf("object %s\n{\n",op->name);
		for( vp = op->common_vars; vp; vp = vp->next )
			printf("var %s;\n",vp->name);
		printf("\n");
		for( cp = op->codelist; cp; cp = cp->next )
			print_code( cp );
		printf("} -- ====== end of object '%s' ====\n",op->name);
	}
	printf("\n} -- ======= end of ENVIRONMENT '%s'\n",e->name);

	if( e->next != NULL )
		printf("-- Hmmm : envlist has more than one entry!!!\n");
	return 0;
}


int
print_Cdecs()
{
C_DCL_PTR	cdp;
int		i;

	if( C_declist == NULL )
		return 0;

	for( cdp = C_declist; cdp; cdp = cdp->next )
	{
		switch( cdp->type )
		{
		case T_Cint:
			printf("Cint ");
			break;
		case T_Cflt:
			printf("Cflt ");
			break;
		case T_Cstr:
			printf("Cstr ");
			break;
		case T_Cfunc:
			printf("Cfunc ");
			break;
		default:
			printf("<print_Cdecs(): ERROR: unknown type>\n");
			break;
		}
		printf("%s",cdp->name);
		if( cdp->type != T_Cfunc )
			printf(";\n");
		else
		{
			printf("( ");
			for( i=0; i<cdp->nparms; i++ )
			{
				switch( cdp->ptype[i] )
				{	
				case T_Cint:
					printf("Cint");
					break;
				case T_Cflt:
					printf("Cflt");
					break;
				case T_Cstr:
					printf("Cstr");
					break;
				default:
					printf("<print_Cdecs(): ERROR: unknown parm type>\n");
					break;			
				}
				if( (i+1) < cdp->nparms )
					printf(", ");
			}
			printf(" )");
			switch( cdp->retval )
			{
			case T_Cint:
				printf(" returns Cint;\n");
				break;
			case T_Cflt:
				printf(" returns Cflt;\n");
				break;
			case T_Cstr:
				printf(" returns Cstr;\n");
				break;
			default:
				printf(";\n");
				break;
			}
		}
	}	
	return 0;
}
