
/* ev_eval.c */

#include <stdio.h>
#include "hash.h"
#include "clink.h"
#include <X10/Xlib.h>
#include "ev_tokens.h"

extern ENV_PTR	curenv;
extern OBJ_PTR	curobj;
extern CODE_PTR	curcode;

extern int 	return_flag;
extern int	next_flag;
extern int	exit_flag;
extern int	exit_rpt_flag;

extern int	ev_discard;

#define ev_FlagsSet	(return_flag || next_flag || exit_flag || exit_rpt_flag)
#define ev_ClearFlags	(ev_discard = return_flag = next_flag = exit_flag = exit_rpt_flag = 0)

#define VAL(vp)	((vp)->type==T_int ? (vp)->val.ival : \
	((vp)->type == T_float ? (vp)->val.fval : 0 ))

typedef void 	(*PF_VOID)();	/* pointer to function returning void */
typedef int 	(*PF_INT)();	/* ... returning int */
typedef char * 	(*PF_STR)();	/* ... returning char * */
typedef float 	(*PF_FLT)();	/* ... returning float */

#define MAXSTACK 15

typedef struct
{
	int	num;	/* number of parms on stack */
	int	cur;	/* current int we are in */
	int	p[MAXSTACK];	/* the parms, stored in ints */
} STACK;

#define INIT_STACK(s) \
	{ int i; for( i=0; i<MAXSTACK; i++ ) (s).p[i]=0; (s).num = (s).cur = 0; }
#define PUSH_INT(s,i) \
	{ (s).p[(s).cur++] = (i); (s).num++; }
#define PUSH_STR(s,str) \
	{ int j; char *news = (str); char *loc; \
	  for( j=0, loc = (char *)&news; j<(sizeof(char *)/sizeof(int)); j++, loc+=sizeof(int) ) \
		bcopy(loc,&((s).p[(s).cur++]),sizeof(int)); \
	  (s).num++; }
#define PUSH_FLT(s,f) \
	{ int j; double d = (f); char *loc; \
	  for( j=0, loc = (char *)&d; j<(sizeof(double)/sizeof(int)); j++, loc+=sizeof(int) ) \
		bcopy(loc,&((s).p[(s).cur++]),sizeof(double)); \
	  (s).num++; }

#define CALL_FUNC(f,s) \
	(f)( (s).p[0],(s).p[1],(s).p[2],(s).p[3],(s).p[4],(s).p[5],(s).p[6],(s).p[7],\
		(s).p[8],(s).p[9],(s).p[10],(s).p[11],(s).p[12],(s).p[13],(s).p[14] )
	
int
ev_EvalExpr( ep, res )
	EXPR_PTR	ep;
	VAR_PTR		res;
{
int *ip;
int *ip2;
VAR v1, v2;
VAR_PTR	vp1, vp2;
char *calloc();

	initvar(&v1);
	initvar(&v2);
	
	EV_DEBUG(3,(">> entering EvalExpr; evaluating "));
	EV_DEBUG(3,(" %s\n",print_expr(ep)));
	
	if( ep && (ep->magic == EXPR_MAGIC) && 
		res && (res->magic == VAR_MAGIC) )
	{
		ip = (int *) ep->left;
		ip2 = (int *) ep->right;

		if( ip && *ip == EXPR_MAGIC )
		{
			ev_EvalExpr((EXPR_PTR) ep->left, &v1);
			vp1 = &v1;
		}
		else if( ip && *ip == FCALL_MAGIC )
		{
			ev_EvalFunc((FCALL_PTR) ep->left, &v1);
			vp1 = &v1;
		}
		else 
			vp1 = ((VAR_PTR) ep->left);

		if( ip2 && *ip2 == EXPR_MAGIC )
		{
			ev_EvalExpr((EXPR_PTR) ep->right, &v2);
			vp2 = &v2;
		}
		else if( ip2 && *ip2 == FCALL_MAGIC )
		{
			ev_EvalFunc((FCALL_PTR) ep->right, &v2);
			vp2 = &v2;
		}
		else
			vp2 = ((VAR_PTR) ep->right);
			
		ev_DoOp( vp1, ep->op, vp2, res );

		EV_DEBUG(3,(">> result of expr: "));
		EV_DEBUG(3,("%s\n",print_var(res)));
		return 0;
	}
	else
	{
		if( !ep || (ep->magic != EXPR_MAGIC) )
			return ev_ExecErr( "bad expr ptr in ev_EvalExpr()" );
		else
			return ev_ExecErr( "bad var ptr in ev_EvalExpr()" );		
	}
}

int
ev_DoOp( varp1, op, varp2, res )
	VAR_PTR	varp1, varp2, res;
	int	op;
{
VAR	v1, v2, temp;
VAR_PTR vp1 = &v1;
VAR_PTR	vp2 = &v2;
VAR_PTR tvp = &temp;
int	r = 0;

	/* first, make a copy of the vars so we don't mess them up with coercions */

	initvar( &temp );
	initvar( vp1 );
	initvar( vp2 );
	if( varp1 )
		bcopy( varp1, &v1, sizeof(VAR) );
	if( varp2 )
		bcopy( varp2, &v2, sizeof(VAR) );

	ev_GetCval( vp1 );	/* does nothing if not C-var */
	ev_GetCval( vp2 );

	if( IsCvar(vp1) )
	{
		if( vp1->type == T_Cint )
			vp1->type = T_int;
		else if( vp1->type == T_Cflt )
			vp1->type = T_float;
		else if( vp1->type == T_Cstr )
			vp1->type = T_string;
	}
	if( IsCvar(vp2) )
	{
		if( vp2->type == T_Cint )
			vp2->type = T_int;
		else if( vp2->type == T_Cflt )
			vp2->type = T_float;
		else if( vp2->type == T_Cstr )
			vp2->type = T_string;
	}

	switch( op )
	{
	case T_and:
		if( IsCvar(res) ) 
		{
			toInt( tvp );
			tvp->val.ival = ( IsTrue(vp1) && IsTrue(vp2) );
			ev_SetCval( res, tvp );
		}
		else
		{
			toInt( res );
			res->val.ival = ( IsTrue(vp1) && IsTrue(vp2) );
		}
		break;
	case T_or:
		if( IsCvar(res) ) 
		{
			toInt( tvp );
			tvp->val.ival = ( IsTrue(vp1) || IsTrue(vp2) );
			ev_SetCval( res, tvp );
		}
		else
		{
			toInt( res );
			res->val.ival = ( IsTrue(vp1) || IsTrue(vp2) );
		}
		break;
	case T_not:
		if( IsCvar(res) )
		{
			toInt( tvp );
			tvp->val.ival = !IsTrue(vp2);
			ev_SetCval( res, tvp );
		}
		else
		{
			toInt(res);
			res->val.ival = !IsTrue(vp2);
		}
		break;
	case T_plus:
		toNum( vp1 );
		toNum( vp2 );
		if( IsInt(vp1) && IsInt(vp2) )
		{
			if( IsCvar(res) )
			{
				toInt( tvp );
				tvp->val.ival = VAL(vp1) + VAL(vp2);
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt( res );
				res->val.ival = VAL(vp1) + VAL(vp2);
			}
		}
		else	/* at least one is float */
		{
			if( IsCvar(res) )
			{
				toFlt( tvp );
				tvp->val.fval = VAL(vp1) + VAL(vp2);
				ev_SetCval( res, tvp );
			}
			else
			{
				toFlt(res);
				res->val.fval = VAL(vp1) + VAL(vp2);
			}
		}
		break;
	case T_times:
		toNum( vp1 );
		toNum( vp2 );
		if( IsInt(vp1) && IsInt(vp2) )
		{
			if( IsCvar(res) )
			{
				toInt( tvp );
				tvp->val.ival = VAL(vp1) * VAL(vp2);
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt( res );
				res->val.ival = VAL(vp1) * VAL(vp2);
			}
		}
		else	/* at least one is float */
		{
			if( IsCvar(res) )
			{
				toFlt( tvp );
				tvp->val.fval = VAL(vp1) * VAL(vp2);
				ev_SetCval( res, tvp );
			}
			else
			{
				toFlt(res);
				res->val.fval = VAL(vp1) * VAL(vp2);
			}
		}
		break;	
	case T_divide:
		toNum( vp1 );
		toNum( vp2 );
		if( VAL(vp2) == 0 || VAL(vp2) == 0.0 )
			return ev_ExecErr( "divide by zero" );
		if( IsInt(vp1) && IsInt(vp2) )
		{
			if( IsCvar(res) )
			{
				toInt( tvp );
				tvp->val.ival = VAL(vp1) / VAL(vp2);
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt( res );
				res->val.ival = VAL(vp1) / VAL(vp2);
			}
		}
		else	/* at least one is float */
		{
			if( IsCvar(res) )
			{
				toFlt( tvp );
				tvp->val.fval = VAL(vp1) / VAL(vp2);
				ev_SetCval( res, tvp );
			}
			else
			{
				toFlt(res);
				res->val.fval = VAL(vp1) / VAL(vp2);
			}
		}
		break;
	case T_minus:
		if( !varp1 )	/* unary minus */
		{
			toNum( vp2 );
			if( IsInt(vp2) )
			{
				if( IsCvar(res) )
				{
					toInt( tvp );
					tvp->val.ival = -1 * VAL(vp2);
					ev_SetCval( res, tvp );
				}
				else
				{
					toInt(res);
					res->val.ival = -1 * VAL(vp2);
				}
			}
			else	/* it's float */
			{
				if( IsCvar(res) )
				{
					toFlt( tvp );
					tvp->val.fval = -1 * VAL(vp2);
					ev_SetCval( res, tvp );
				}
				else
				{
					toFlt(res);
					res->val.fval = -1 * VAL(vp2);
				}
			}			
		}
		else	/* binary minus */
		{
			toNum( vp1 );
			toNum( vp2 );
			if( IsInt(vp1) && IsInt(vp2) )
			{
				if( IsCvar(res) )
				{
					toInt( tvp );
					tvp->val.ival = VAL(vp1) - VAL(vp2);
					ev_SetCval( res, tvp );
				}
				else
				{
					toInt( res );
					res->val.ival = VAL(vp1) - VAL(vp2);
				}
			}
			else	/* at least one is float */
			{
				if( IsCvar(res) )
				{
					toFlt( tvp );
					tvp->val.fval = VAL(vp1) - VAL(vp2);
					ev_SetCval( res, tvp );
				}
				else
				{
					toFlt(res);
					res->val.fval = VAL(vp1) - VAL(vp2);
				}
			}		
		}
		break;
	case T_equal:	/* are they the same? */
		if( IsStr(vp1) && IsStr(vp2) )
		{
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = !strcmp(vp1->val.sval,vp2->val.sval);
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = !strcmp(vp1->val.sval,vp2->val.sval);
			}
		}
		else	/* make both numeric */
		{
			toNum(vp1);
			toNum(vp2);
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = ( VAL(vp1) == VAL(vp2) );
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = ( VAL(vp1) == VAL(vp2) );
			}
		}
		break;
	case T_cat:
		toStr( vp1 );
		toStr( vp2 );
		if( IsCvar(res) )
		{
			toStr(tvp);
			strcpy( tvp->val.sval, vp1->val.sval );
			strcat( tvp->val.sval, vp2->val.sval );
			ev_SetCval( res, tvp );
		}
		else
		{
			toStr( res );
			strcpy( res->val.sval, vp1->val.sval );
			strcat( res->val.sval, vp2->val.sval );
		}
		break;
	case T_catspace:	/* concatenate with space between */
		toStr( vp1 );
		toStr( vp2 );
		if( IsCvar(res) )
		{
			toStr(tvp);
			strcpy( tvp->val.sval, vp1->val.sval );
			strcat( tvp->val.sval, " ");
			strcat( tvp->val.sval, vp2->val.sval );
			ev_SetCval( res, tvp );
		}
		else
		{
			toStr( res );
			strcpy( res->val.sval, vp1->val.sval );
			strcat( res->val.sval, " ");
			strcat( res->val.sval, vp2->val.sval );
		}
		break;
	case T_LT:		/* less than */
		if( IsStr(vp1) && IsStr(vp2) )
		{
			if( strcmp(vp1->val.sval,vp2->val.sval) < 0 )
				r = 1;
			else
				r = 0;
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		else	/* numeric */
		{
			toNum(vp1);
			toNum(vp2);
			r = (VAL(vp1) < VAL(vp2));
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}				
		}
		break;
	case T_GT:		/* greater than */
		if( IsStr(vp1) && IsStr(vp2) )
		{
			if( strcmp(vp1->val.sval,vp2->val.sval) > 0 )
				r = 1;
			else
				r = 0;
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		else	/* numeric */
		{
			toNum(vp1);
			toNum(vp2);
			r = (VAL(vp1) > VAL(vp2));
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		break;
	case T_notequal:
		if( IsStr(vp1) && IsStr(vp2) )
		{
			if( strcmp(vp1->val.sval,vp2->val.sval) != 0 )
				r = 1;
			else
				r = 0;
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		else	/* numeric */
		{
			toNum(vp1);
			toNum(vp2);
			r = (VAL(vp1) != VAL(vp2));
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		break;
	case T_LTE:	/* <= */
		if( IsStr(vp1) && IsStr(vp2) )
		{
			if( strcmp(vp1->val.sval,vp2->val.sval) <= 0 )
				r = 1;
			else
				r = 0;
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		else
		{
			toNum(vp1);
			toNum(vp2);
			r = (VAL(vp1) <= VAL(vp2));
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		break;
	case T_GTE:	/* >= */
		if( IsStr(vp1) && IsStr(vp2) )
		{
			if( strcmp(vp1->val.sval,vp2->val.sval) >= 0 )
				r = 1;
			else
				r = 0;
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		else
		{
			toNum(vp1);
			toNum(vp2);
			r = (VAL(vp1) >= VAL(vp2));
			if( IsCvar(res) )
			{
				toInt(tvp);
				tvp->val.ival = r;
				ev_SetCval( res, tvp );
			}
			else
			{
				toInt(res);
				res->val.ival = r;
			}
		}
		break;
	case T_NULL:		/* no-op; just one var in expression */
		if( varp1 && !varp2 )
		{
			if( IsCvar(res) )
				ev_SetCval(res,vp1);
			else
			{
				res->type = vp1->type;
				switch( vp1->type )
				{
				case T_int:
					res->val.ival = vp1->val.ival;
					break;
				case T_float:
					res->val.fval = vp1->val.fval;
					break;
				case T_string:
					strcpy( res->val.sval, vp1->val.sval);
					break;
				default:
					return ev_ExecErr( "unknown var1 type in ev_DoOp()" );
					break;
				}
			}
		}
		else if( !varp1 && varp2 )
		{
			if( IsCvar(res) )
				ev_SetCval(res,vp2);
			else
			{
				res->type = vp2->type;
				switch( vp2->type )
				{
				case T_int:
					res->val.ival = vp2->val.ival;
					break;
				case T_float:
					res->val.fval = vp2->val.fval;
					break;
				case T_string:
					strcpy( res->val.sval, vp2->val.sval);
					break;
				default:
					return ev_ExecErr( "unknown var2 type in ev_DoOp()" );
					break;
				}
			}
		}
		else
			return ev_ExecErr( "bad no-op variable in expression" );
		break;
	default:
		return ev_ExecErr( "unknown op in DoOp()" );
		break;
	}
	return 0;
}


int
ev_EvalFunc( fcp, res )
	FCALL_PTR	fcp;
	VAR_PTR		res;
{
CODE_PTR	cp,temp;
C_DCL_PTR	cdp;
VAR_PTR		vp;
VAR_PTR		save_list = NULL;
VAR		tv;
VAR_PTR		tvp = &tv;
EXPR_PTR	ep;
FCALL_PTR	tfcp;
int		i;
HashNodePtr	hnp;
int *		ip;
VAR		tret;
VAR_PTR		trp = &tret;
STACK		s;
char *		tempstr;

	EV_DEBUG(3,(">> entering EvalFunc\n"));

	if( !fcp || fcp->magic != FCALL_MAGIC )
		return -1;

	initvar(tvp);
	initvar(trp);

	cp = fcp->func;
	if( cp->nparms != fcp->nparms )
		return ev_ExecErr( "parameter number mismatch" );

	if( cp->type == CFUNC_CODESEG )
	{
		hnp = cprog_lookup( C_ht, cp->name );
		if( !hnp )
			ev_ExecErr( "C function not found in table" );

		cdp = findCdcl( cp->name );
		if( !cdp )
			ev_ExecErr( "C function not in declarations list" );
		INIT_STACK( s );
	}
	else if( cp->type == FUNC_CODESEG )
		save_list = save_vars( cp );

	for( i=0; i<fcp->nparms; i++ )
	{
		ip = (int *) fcp->parms[i];
		if( ip && *ip == VAR_MAGIC )
		{
			vp = (VAR_PTR) fcp->parms[i];
			ev_GetCval( vp );	/* no effect if not C-thing */
			ev_CopyVal( vp, cp->parms[i] );
		}
		else if( ip && *ip == EXPR_MAGIC )
		{
			ep = (EXPR_PTR) fcp->parms[i];
			ev_EvalExpr( ep, tvp );
			ev_CopyVal( tvp, cp->parms[i] );
		}
		else if( ip && *ip == FCALL_MAGIC )
		{
			tfcp = (FCALL_PTR) fcp->parms[i];
			ev_EvalFunc( tfcp, tvp );
			ev_CopyVal( tvp, cp->parms[i] );
		}
		else
			return ev_ExecErr( "unknown parameter type in ev_Fcall()" );
		
		if( cp->type == CFUNC_CODESEG )	/* coerce the params to correct type */
		{
			switch( cdp->ptype[i] )
			{
			case T_Cint:
				toInt( cp->parms[i] );
				PUSH_INT( s, cp->parms[i]->val.ival );
				break;
			case T_Cflt:
				toFlt( cp->parms[i] );
				PUSH_FLT( s, cp->parms[i]->val.fval );
				break;
			case T_Cstr:
				toStr( cp->parms[i] );
				PUSH_STR( s, cp->parms[i]->val.sval );
				break;
			default:
				break;
			}
		}
	}

	ev_InitVars( cp );		/* this will not affect the parms */
	initvar( &cp->returned );	/* prepare the return value */

	if( cp->type == CFUNC_CODESEG )
	{
		switch( cdp->retval )
		{
		case 0:
			CALL_FUNC( ((PF_VOID)hnp->ptr), s );
			break;
		case T_Cint:
			toInt( trp );
			trp->val.ival = CALL_FUNC( ((PF_INT)hnp->ptr), s );
			break;
		case T_Cflt:
			toFlt( trp );
			trp->val.fval = CALL_FUNC( ((PF_FLT)hnp->ptr), s );
			break;
		case T_Cstr:
			toStr( trp );
			tempstr = CALL_FUNC( ((PF_STR)hnp->ptr), s );
			strcpy( trp->val.sval, tempstr );
			break;
		default:
			return ev_ExecErr( "unexpected return type in ev_EvalFunc()" );
			break;
		}

		ev_CopyVal( trp, res );
	}
	else if( cp->type == FUNC_CODESEG )	/* normal function */
	{
		/* save state of currently executing code seg */

		temp = curcode;
		curcode = cp;

		ev_ExecBlock(cp->code,0);
		ev_CopyVal( &cp->returned, res );
		ev_ClearFlags;	/* a macro */

		/* restore state */

		restore_vars( cp, save_list );
		curcode = temp;
	}

	/* now, copy back the values of any var parms that were changed by the function */

	for( i=0; i<fcp->nparms; i++ )
	{
		ip = (int *) fcp->parms[i];
		if( ip && *ip == VAR_MAGIC )
		{
			vp = (VAR_PTR) cp->parms[i];
			ev_CopyVal( vp, fcp->parms[i] );
		}
	}

	EV_DEBUG(3,(">> leaving EvalFunc\n"));
	return 0;
}

int
ev_CopyVal( vp1, vp2 )

	VAR_PTR	vp1, vp2;
{
	if( !vp1 || !vp2 )
		return -1;

	ev_GetCval(vp1);

	if( IsCvar(vp2) )
	{
		ev_SetCval( vp2, vp1 );
		return 0;
	}
	
	switch( vp1->type )
	{
	case T_int:
	case T_Cint:
		toInt(vp2);
		vp2->val.ival = vp1->val.ival;
		break;
	case T_float:
	case T_Cflt:
		toFlt(vp2);
		vp2->val.fval = vp1->val.fval;
		break;
	case T_string:
	case T_Cstr:
		toStr(vp2);
		strcpy(vp2->val.sval,vp1->val.sval);
		break;
	default:
		break;
	}
	return 0;
}
