/* 
 * demo2.c - example of X Toolkit usage
 *
 * This code will:
 *	use the external resource file
 * 	obtain resources from the resource manager
 *	create a button box 
 *      add command buttons to a button box
 *	give each command button a unique return tag
 *	provide a simple geometry manager for the button box
 * 
 * Make executable with:
 * cc -o demo2 demo2.c -lXt -lX
 *
 */

#include	<X/Xlib.h>
#include	"Toolkit.h"
#include	<stdio.h>


#define max(x,y) ((x) > (y) ? (x) : (y))

static Window pw1, bbw1;
static Pixmap	border;
static Pixmap	bg;
static int	borderwidth = 1;
static char	*resfile = "demo2.res";
static char	ButtonName[] = "Command";
static char	thisButtonName[32];
static char	thisButtonNum[8];

/* Call back procedure for the command buttons */
static void MyFunc(p)
    caddr_t p;
{ printf("MyFunc called with %d\n", p); sleep(1); }

/* This handler will perform geometry management on the button box */
static XtEventReturnCode EventHandler(event, eventdata)
XEvent *event;
caddr_t eventdata;
{
    WindowInfo		wi;
    XtEventReturnCode code;

    switch (event->type) {
	case ResizeWindow:
	    if (XQueryWindow(bbw1, &wi)) {
		XChangeWindow(bbw1,
		   max(1, ((XExposeEvent *)event)->width-20-2*wi.bdrwidth),
		   max(1, ((XExposeEvent *)event)->height-20-2*wi.bdrwidth));
	    }
	case MessageEvent: break;
        case DestroyWindow: exit(0); break;
    }
    return (processed);
}


void main(argc, argv)
int argc;
char **argv;
{
    Display	*d;
    Window	ww;
    Arg		buttons[10];
    int		buttoncount, x, y, width;
    AtomList	name, class;
    WindowInfo	wi;

/* Arglists for creating the widgets */

    static Arg commandarglist[] = {
	{XtAName,	(caddr_t) thisButtonName},
	{XtAFunction,	(caddr_t) MyFunc},
	{XtAParameter,	(caddr_t) NULL},
	{NULL,		NULL}
    };


    static Arg bbarglist[] = {
	{NULL, NULL}
    };


/* Resource List for obtaining width and colors */
static Resource resourcelist[] = {
    {XtABorderWidth, XtAint, XtAint,
        sizeof(int), (caddr_t)&borderwidth, (caddr_t)NULL},
    {XtABorder, XtAcolor, XtApixmap,
        sizeof(Pixmap), (caddr_t)&border, (caddr_t)NULL},
    {XtABackground, XtAcolor, XtApixmap,
        sizeof(Pixmap), (caddr_t)&bg, (caddr_t)NULL},
    {NULL, NULL, NULL, 0, NULL, NULL}
};


    ResourceDataBase	db;
    FILE		*rdbFile;
    XrmValue		val;
    int	i;

/* Macro to add button to button array and increment button count */
#define addbutton(w) \
    buttons[buttoncount].name = XtAWindow; \
    buttons[buttoncount].value = (caddr_t) w; \
    buttoncount++;


/* Initiialize the display and the toolkit */
    d = XOpenDisplay(NULL);
    XtInitToolkit();

/* Read resource file and get resources */
    rdbFile = fopen(resfile, "r");
    if (rdbFile == NULL) {
        fprintf (stderr, "Can't open resource file %s\n", resfile);
        exit();
    }
    XtGetDataBase(rdbFile, &db);
    XtSetCurrentDataBase(db);
    fclose(rdbFile);
    border = BlackPixmap;
    bg = WhitePixmap;
    XtGetResources(
	resourcelist, NULL, RootWindow,
	XtMakeAtom("ButtonTest"), XtMakeAtom("app"),
	&name, &class);

/* Parent window for the button box */
    pw1 = XCreateWindow(
	RootWindow,
	100, 100,
	400, 200,
	borderwidth, border, bg);

	
/* Create the button box */
    bbw1 = XtCreateButtonBox(pw1, bbarglist);


/*  Create 10 command buttons with unique tags and add to button box*/
    buttoncount = 0;
    for (i=0; i<10; i++) {
        sprintf(thisButtonNum, "%d", i);
        strcat(strcpy(thisButtonName,ButtonName), thisButtonNum);
        commandarglist[2].value = (caddr_t) i;
	ww = XtCreateCommand(bbw1, commandarglist);
	XMapWindow(ww);
	addbutton(ww);
    }
    (void) XtButtonBoxAddButton(bbw1, buttons);


/* Map the button box window, set event handler for the parent window,
   and map the parent window */
    XMapWindow(bbw1);
    XtSetXEventDispatch(
	pw1, (XtEventProc)EventHandler, ExposeWindow, (caddr_t) NULL);
    XMapWindow(pw1);

/* Get and dispatch events */
    for(;;) {
	XEvent ev;
	XNextEvent(&ev);
	(void) XtDispatchXEvent(&ev);
    }

}
