#include "widgetclass.h"
#include "win_dep.h"
#include "string.h"
#include "closure.h"
#include "cont.h"
#include "num.h"
#include "wob.h"

XtAppContext app_context;
Display* dpy;
int screen;
Widget top_level;
extern int main_argc;
extern char **main_argv;
static int end_loop = False;

w_init_object(win)
     WinStruct* win;
{
  win->widget = 0;
}


w_initialize(win)
     WinStruct* win;
{
  top_level = XtVaAppInitialize(&app_context,
				"Whemey",  /* these are all temp settings*/
				0,0,
				(Cardinal*)&main_argc,
				main_argv,
				NULL,	
				NULL);	/* args */

  win->widget = top_level;
  dpy = XtDisplay(top_level);
  screen = DefaultScreen(dpy);
}

w_end_main_loop()
{
  end_loop = True;
}

w_main_loop()
{
  XEvent event;
  XtRealizeWidget(top_level);

  while (end_loop == False) {
    XtAppNextEvent(app_context, &event);
    XtDispatchEvent(&event);
  }
  end_loop = False;
}

w_destroy(win)
     WinStruct* win;
{
  XtDestroyWidget(win->widget);
}

w_make_widget(win, type, parent, name)
     WinStruct *win;
     WidgetClass* type;
     WinStruct *parent;
     char* name;
{
  win->widget = XtCreateManagedWidget(name, type, parent->widget, 0,0);
}

w_make_popup_widget(win, type, parent, name)
     WinStruct *win;
     WidgetClass* type;
     WinStruct *parent;
     char* name;
{
  win->widget = XtCreatePopupShell(name, type, parent->widget, 0,0);
}

void w_hide_widget(win)
     WinStruct* win;
{
  XtUnmanageChild(win->widget);
}

void w_show_widget(win)
     WinStruct* win;
{
  XtManageChild(win->widget);
  XtRealizeWidget(win->widget);
}
void w_popup_widget(win)
     WinStruct* win;
{
  XtPopup(win->widget, XtGrabExclusive);
}

void w_popdown_widget(win)
     WinStruct* win;
{
  XtPopdown(win->widget);
}

w_set_value(win, key, val)
     WinStruct* win;
     String key;
     LLObj* val;
{
  if(llobj_tag(val) == llstring_t) {

    char* buffer;
    LLString* str = (LLString*)val;
    XtVaSetValues(win->widget, 
		  key, llcstring_to_chars(str),
		  0);

  } else if(llobj_tag(val)== llnum_t) 
    XtVaSetValues(win->widget, 
		  key,((int)llnum_to_double((LLNum*)val)),
		  0);
  else if(llobj_tag(val) == llwob_t)
    XtVaSetValues(win->widget, 
		  key, wob2widget(((Wob*)val)),
		  0);
  else if(val == NIL) 
    XtVaSetValues(win->widget, 
		  key, False, 
		  0);
  else if(val == T) 
    XtVaSetValues(win->widget, 
		  key, True, 
		  0);

}

LLObj* w_get_value(win, key, type)
     WinStruct* win;
     String key;
     LLTag type;
{
  void* value;
  XtVaGetValues(win->widget, key, &value, NULL);

  if(type == llnum_t)
    return (LLObj*)lldouble_to_num(((double)((int)value)));
  else if(type == llstring_t)
    return (LLObj*)llcchars_to_string(((char*)value));
  else if(type == llnull_t)
    return ((LLObj*)(value ? T : NIL));

}

/*ARGSUSED*/
void w_callback(w, proc, cbstruct)
     Widget w;
     LLObj* proc;
     void* cbstruct;
{
  lltop_level_form(llcmake_cons(proc, NIL));
}

w_set_callback(win, key, proc)
     WinStruct* win;
     String key;
     LLObj* proc;
{
  XtAddCallback(win->widget, key, w_callback, proc);
}

w_keyboard_focus(topwin,win)
     WinStruct* win;
     WinStruct* topwin;
{
  XtSetKeyboardFocus(topwin->widget, win->widget);
}
