/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include "kcll.h"
int is_a_script = 0;
char *scriptname;
main(argc, argv)
     int argc; 
     char *argv[]; 
{
  LLObj *obj;
  static int util_initted = 0;

  parse_args(argc, argv);

# ifdef MALLOC_DEBUG
    malloc_debug(2);		/* 0 = off, 1 = some debugging, 2 = major debugging! */
# endif
  if(!is_a_script) printf ("Hmm ................ Airplane!\n");
  llinit_mem();
  llinit_obj();
  llinit_sym();
  llinit_closure();
  llinit_env();
  llinit_string();
  llinit_cont(); 
  llinit_stream();
  llinit_delay();
  llinit_read();
  llinit_cons();
  llinit_num();
  llinit_gc();
  llinit_lbc();
  llinit_comp();
  llinit_vector();
  llinit_error();
  llinit_util();
  
  
  if(is_a_script ) {
    char buffer[1024];

    is_a_script = 0;
    sprintf(buffer, "(scriptload \"%s\")", scriptname);
    llcexecute_chars(buffer);
    exit(0);
  }

  while (1) { /* Top level */
    llstrprintf (s_stdout, "\n %08X (%d/%d) Hey Limey Lisp Programmer> ", sbrk(0), llcheap_size(), llcheap_ceiling());
    if(!(obj = llread_obj(s_stdin))) exit(0);
    llprint_obj(lltop_level_form(obj), s_stdout);
    llcmaybe_gc();
  }
}

parse_args(argc, argv)
     int argc ;
     char **argv;
{
  argc--;
  argv++;
  while(argc) {

    if(!strncmp(*argv, "-s", 2)) {
      argv++; 
      argc--;
      if(!argc) {
	fprintf(stderr, "Need to have a filename for a script\n");
      }
      scriptname = *argv;
      is_a_script = 1;
    }
    argv++;
    argc--;
  }
}
