/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

/* 
  Support for streams
*/

#ifndef _STREAM_INC
#define _STREAM_INC

#include <stdio.h>
#include "kcll.h"
#include "obj.h"
#define LLLOOK_AHEAD_SIZE 7
typedef enum streamtype_e { 
  LLFILE, 
  LLCSTRING
  } StreamType; 
typedef struct llstream_s {
  LLIS_OBJECT;
  StreamType type; 
  union { 
    FILE *file;			/* Only possibility for now */
    char *string; 
  } data; 
  int mode;
  unsigned char look_ahead[LLLOOK_AHEAD_SIZE]; 
  int buffered_chars;
} LLStream;

extern LLTag llstream_t;		/* Stream tag magic number */
extern LLStream *s_stdin;		/* Stream objects */
extern LLStream *s_stdout;
extern LLStream *s_stderr;

void llstrprintf();

LLStream *llmake_stream_to_file ();
LLStream *llmake_stream_from_chars ();
 
typedef enum llfiletype_e { 
  LLINPUTFILE, 
  LLOUTPUTFILE,
  LLAPPENDFILE,
  LLUPDATEFILE,
} LLFileType;


#endif
