#include "wob.h"
#include "string.h"
#include "stream.h"


LLTag llwob_t;
LLObj* wob_main_loop_retval;

void llmake_wob_() {
  LLWidgetClass* wob_type;
  Wob* wob;
  Wob* parent_wob;
  static int wob_counter = 0;
  char buffer[20];

  parent_wob = (Wob*) llnextcheckedarg(llwob_t);
  wob_type = (LLWidgetClass*) (llnextcheckedarg(llwidgetclass_t));
  lllastarg();

  wob = (Wob*)llmake_obj(llwob_t);

  wob->extra = NULL;
  wob->type = wob_type;
  wob->parent = parent_wob;
  wob->children = (LLCons*)NIL;
  
  sprintf(buffer, "wob-%d", wob_counter++);
  wob->name = llcchars_to_string(buffer);

  w_init_object(&wob->win);
  wob->type->constructor(wob);
  llpusharg((LLObj*)wob);
}

void llwob_get_type()
{
  
  Wob* wob;
  wob = (Wob*) llnextcheckedarg(llwob_t);
  lllastarg();
  llpusharg(wob->type);

}

void llwob_get_children()
{
  Wob* wob;
  wob = (Wob*) llnextcheckedarg(llwob_t);
  lllastarg();
  llpusharg(wob->children);
}

void llwob_set_childrenbang()
{
  Wob* wob;
  LLCons* children;
  wob = (Wob*) llnextcheckedarg(llwob_t);
  children = (LLCons*) llnextcheckedarg(llcons_t);
  lllastarg();
  wob->children = children;
  llpusharg(wob->children);
}

void llwob_get_name()
{
  Wob* wob;
  wob = (Wob*) llnextcheckedarg(llwob_t);
  lllastarg();
  llpusharg(wob->name);
}


static void wob_free(obj)
     LLObj* obj;
{
  Wob* wob;
  wob = (Wob*) obj;
  printf("freewob \n");
  if(wob->extra) free(wob->extra);
  w_destroy(&wob->win);
}

/*ARGSUSED*/
static void wob_touch(obj) 
     LLObj* obj;
{
  Wob* wob = (Wob*)obj;
  lltouch_obj(wob->children);
  lltouch_obj(wob->name);
  lltouch_obj(wob->parent);
}


void wob_print(obj, stream)
     LLObj* obj;
     LLStream* stream;
{
}


void llwob_initialize()
{
  Wob* wob;

  lllastarg();

  wob = (Wob*)llmake_obj(llwob_t);
  wob->type = (LLWidgetClass*)NIL;
  wob->parent = (Wob*)NIL;
  wob->children = (LLCons*)NIL;
  wob->name = (LLString*)NIL;
  w_initialize(&wob->win);
  llpusharg(wob);
}

void llwob_main_loop()
{
  lllastarg();
  w_main_loop();
  llpusharg(wob_main_loop_retval);
  wob_main_loop_retval = NIL;
}

void llwob_main_loop_return()
{
  wob_main_loop_retval = llnextarg();
  lllastarg();
  w_end_main_loop();
  llpusharg(wob_main_loop_retval);
}

void llwob_set_value()
{
  Wob* wob;
  LLString *str;
  LLObj* val;
  char *buffer;

  wob = (Wob*)llnextcheckedarg(llwob_t);
  str = (LLString*)llnextcheckedarg(llstring_t);
  val = (LLObj*)llnextarg();
  lllastarg();

  buffer = llcstring_to_malloc_chars(str);
  w_set_value( &wob->win, buffer, val );
  free(buffer);
  llpusharg(T);
}

void llwob_get_value()
{
  Wob* wob;
  LLObj* val;
  LLString* str;
  char *buffer;

  wob = (Wob*)llnextcheckedarg(llwob_t);
  str = (LLString*)llnextcheckedarg(llstring_t);
  val = (LLObj*)llnextarg();
  lllastarg();

  buffer = llcstring_to_malloc_chars(str);
  llpusharg(w_get_value( &wob->win, buffer, llobj_tag(val) ));
  free(buffer);
}

void llwob_set_callback()
{
  Wob* wob;
  LLString *str;
  LLObj* val;
  char *buffer;

  wob = (Wob*)llnextcheckedarg(llwob_t);
  str = (LLString*)llnextcheckedarg(llstring_t);
  val = (LLObj*)llnextarg();
  lllastarg();

  buffer = llcstring_to_malloc_chars(str);
  w_set_callback( &wob->win, buffer, val );
  free(buffer);
  llpusharg(T);
}

void llwob_set_keyboard_focus()
{
  Wob* top_wob, *wob;
  top_wob = (Wob*)llnextcheckedarg(llwob_t);
  wob = (Wob*)llnextcheckedarg(llwob_t);
  lllastarg();

  w_keyboard_focus(&top_wob->win, &wob->win);
  
  llpusharg(T);
}

void llwob_show()
{
  Wob* wob;
  wob = (Wob*)llnextcheckedarg(llwob_t);

  wob->type->show(wob);
  llpusharg(T);
}

void llwob_hide()
{
  Wob* wob;
  wob = (Wob*)llnextcheckedarg(llwob_t);
  
  wob->type->hide(wob);
  llpusharg(T);
}

void wob_ll_init() {

  llwob_t = lladd_obj_td(sizeof(Wob), "Wob",
			 wob_free, wob_touch, 0, 0);

  llregister_cfunc(llmake_wob_, "make-wob-Priv");
  llregister_cfunc(llwob_initialize, "wob-initialize");
  llregister_cfunc(llwob_main_loop, "wob-main-loop");
  llregister_cfunc(llwob_main_loop_return, "wob-main-loop-return");
  llregister_cfunc(llwob_set_value, "wob-set-value");
  llregister_cfunc(llwob_get_value, "wob-get-value");
  llregister_cfunc(llwob_set_callback, "wob-set-callback");
  llregister_cfunc(llwob_set_childrenbang, "wob-set-children!");
  llregister_cfunc(llwob_get_children, "wob-get-children");
  llregister_cfunc(llwob_get_name, "wob-get-name");
  llregister_cfunc(llwob_get_type, "wob-get-type");
  llregister_cfunc(llwob_set_keyboard_focus, "wob-set-keyboard-focus");
  llregister_cfunc(llwob_show, "wob-show");
  llregister_cfunc(llwob_hide, "wob-hide");
}


wob_init()
{

  wob_ll_init();
  llwidgetclass_init();

  Xt_widget_set_init();

  add_env(tlge, llcstring_to_sym("whoopie-config-file"),
	  llcchars_to_string(LLWHOOPIE_FILE));
}
