#ifndef lint
static char *RCSid = "$Header: /m/webster/src/c/server/RCS/webster.c,v 1.2 86/12/26 22:03:09 davy Exp $";
#endif

/*
 * webster.c - dispatch commands received.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * April, 1986
 *
 * $Log:	webster.c,v $
 * Revision 1.2  86/12/26  22:03:09  davy
 * Changed to work with DBM files.
 * 
 */
#include <signal.h>
#include <stdio.h>

#include "../h/webster.h"

extern FILE *input;
extern FILE *output;

/*
 * webster - the start of the service process.
 */
webster()
{
	int ac;
	char *args[8];
	char buf[BUFSIZ];
	extern int timeout();

	/*
	 * They get TIMEOUT minutes of idle time before
	 * we bag them.
	 */
	signal(SIGALRM, timeout);
	alarm(TIMEOUT);

	/*
	 * Read lines...
	 */
	while (fgets(buf, BUFSIZ, input) != NULL) {
		/*
		 * Turn off alarm clock.
		 */
		alarm(0);

		/*
		 * Clean up the line.
		 */
		clean(buf);

		if (*buf == NULL)
			continue;

		/*
		 * Split the line into words.
		 */
		split(buf, args, &ac);

		/*
		 * Dispatch the command.
		 */
		dispatch(ac, args);

		fflush(output);

		/*
		 * Reset the alarm.
		 */
		alarm(TIMEOUT);
	}
}

/*
 * clean - clean up a string.
 */
clean(s)
register char *s;
{
	while (*s) {
		*s &= 0177;

		if ((*s == '\r') || (*s == '\n'))
			*s = NULL;

		s++;
	}
}

/*
 * split - turn s into separate word arguments.
 */
split(s, args, ac)
register char *s;
char **args;
int *ac;
{
	*ac = 0;

	while (*s) {
		while ((*s != NULL) && ((*s == ' ') || (*s == '\t')))
			*s++ = NULL;

		args[(*ac)++] = s;

		while ((*s != NULL) && (*s != ' ') && (*s != '\t'))
			s++;
	}

	args[*ac] = NULL;
}

/*
 * dispatch - dispatch the command to the right routine.
 */
dispatch(ac, args)
int ac;
char **args;
{
	if (!strcmp(*args, "DEFINE"))
		return(define(ac, args));

	if (!strcmp(*args, "COMPLETE"))
		return(complete(ac, args));

	if (!strcmp(*args, "ENDINGS"))
		return(endings(ac, args));

	if (!strcmp(*args, "SPELL"))
		return(spell(ac, args));

	if (!strcmp(*args, "HELP"))
		return(help(ac, args));

	error(0, "Unknown command: %s", *args);
	return(-1);
}

/*
 * error - print error messages.
 */
error(fatal, s, arg)
int fatal;
char *s, *arg;
{
	if (fatal) {
		fprintf(output, "ERROR FATAL");
		fprintf(output, s, arg);
		fprintf(output, "\r\n");
		byebye();
	}

	fprintf(output, "ERROR RECOVERABLE");
	fprintf(output, s, arg);
	fprintf(output, "\r\n");
}

/*
 * haswild - check for wildcard characters.
 */
haswild(s)
register char *s;
{
	while (*s) {
		if ((*s == ONECH) || (*s == MANYCH))
			return(1);
		s++;
	}

	return(0);
}

/*
 * isnumber - see if s is a number.
 */
isnumber(s)
register char *s;
{
	while (*s) {
		if ((*s < '0') || (*s > '9'))
			return(0);
		s++;
	}

	return(1);
}

timeout()
{
	error(1, "Server disconnecting; connection idle too long.", 0);
	byebye();
}
