/*
 * firstletter - print a count of how many words start with each letter.
 *
 * David A. Curry
 * Purdue University
 * davy@ee.purdue.edu
 * April, 1986
 */
#include <stdio.h>
#include "../h/wordfiles.h"

int letters[256];

main()
{
	char buf[BUFSIZ];
	register FILE *fp;
	register int i, j;

	for (i=0; i < NWORDFILES; i++) {
		sprintf(buf, "%s/%s", wordfiledir, wordfiles[i]);

		if ((fp = fopen(buf, "r")) == NULL) {
			fprintf(stderr, "firstletter: cannot open \"%s\".\n", buf);
			continue;
		}

		while (fgets(buf, BUFSIZ, fp) != NULL) {
			if (*buf == 'F')
				letters[buf[2]]++;
		}

		fclose(fp);
	}

	j = 0;
	for (i=0; i < 256; i++) {
		if (letters[i])
			printf("%c: %d\n", (char) i, letters[i]);
		j += letters[i];
	}

	printf("--- %d total words\n", j);
	exit(0);
}
