#ifndef lint
static char *RCSid = "$Header: search.c,v 1.1 87/01/18 13:26:19 halazar Exp $";
#endif

/*
 * search.c - dictionary search routines.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * April, 1986
 *
 * $Log:	search.c,v $
 * Revision 1.1  87/01/18  13:26:19  halazar
 * Initial revision
 * 
 * Revision 1.2  86/12/26  22:02:59  davy
 * Changed to work with DBM files.
 * 
 */
#include <sys/types.h>
#include <ctype.h>
#include <stdio.h>
#include <ndbm.h>

#include "../h/index.h"
#include "../h/webster.h"

extern DBM *db;				/* index database		*/
extern FILE *indexfp;			/* index file pointer		*/
extern struct header hdr;		/* index file header		*/

int nanswers = 0;			/* number of answers found	*/
int answers_valid = 0;			/* non-zero if numbers valid	*/
struct answer answers[MAXANSWERS];	/* answers we find		*/

/*
 * adjust - try to adjust the bounds of the search to only those words
 *	    that start with the same first character as the word we
 *	    are looking for.
 */
adjust(word, low, high)
char *word;
daddr_t *low, *high;
{
	int x;

	if (isalpha(*word)) {
		*low = hdr.h_starts[SUBSCRIPT(*word)];
		*high = (*word == 'z' ? hdr.h_idxsize : hdr.h_starts[SUBSCRIPT((*word) + 1)]);
	}
	else if (isdigit(*word)) {
		*low = hdr.h_starts[SUBSCRIPT(*word)];
		*high = hdr.h_starts[(*word == '9' ? SUBSCRIPT('a') : SUBSCRIPT((*word) + 1))];
	}
	else if (*word == '-') {
		*low = hdr.h_starts[SUBSCRIPT('-')];
		*high = hdr.h_starts[SUBSCRIPT('0')];
	}
	else if (*word == '\'') {
		*low = hdr.h_starts[SUBSCRIPT('\'')];
		*high = hdr.h_starts[SUBSCRIPT('-')];
	}
	else {
		*low = 0;
		*high = hdr.h_idxsize;
	}

	if (*low > *high) {
		x = *low;
		*low = *high;
		*high = x;
	}
}

/*
 * easysearch - simple binary search
 */
easysearch(word, start)
char *word;
int start;
{
	datum key, content;

	nanswers = start;

	key.dptr = word;
	key.dsize = strlen(word);

	content = dbm_fetch(db, key);

	if (content.dptr != NULL) {
		strcpy(answers[nanswers].a_word, word);
		answers[nanswers].a_idx = *(struct index *) content.dptr;
		answers[nanswers].a_idxok = 1;
		nanswers++;
	}
}

/*
 * wildsearch - handle limited regular expressions - ONECH matches a single
 *		character, MANYCH matches zero or more characters.
 */
wildsearch(word, start)
char *word;
int start;
{
	char buf[BUFSIZ];
	register int len;
	daddr_t addr, low, high;

	/*
	 * Adjust our search field.
	 */
	nanswers = start;
	adjust(word, &low, &high);

	/*
	 * Seek to first word.
	 */
	addr = low;
	fseek(indexfp, low, 0);

	/*
	 * Look for words.
	 */
	while ((addr <= high) && (fgets(buf, BUFSIZ, indexfp) != NULL)) {
		len = strlen(buf);

		addr += len;
		buf[len - 1] = NULL;

		if (match1(buf, word)) {
			strcpy(answers[nanswers].a_word, buf);
			answers[nanswers].a_idxok = 0;
			nanswers++;
		}

		if (nanswers >= MAXANSWERS)
			return;
	}
}

match1(s, t)
register char *s, *t;
{
	register short c, x;

	if (x = *s++) {
		if ((x &= 0177) == 0)
			x = 0200;
	}

	switch (c = *t++) {
	default:
		if (c != x)
			return(0);
	case ONECH:
		if (x)
			return(match1(s, t));
		return(0);
	case MANYCH:
		return(match2(--s, t));
	case NULL:
		return(!x);
	}
}

match2(s, t)
register char *s, *t;
{
	if (*t == NULL)
		return(1);

	while (*s) {
		if (match1(s++, t))
			return(1);
	}

	return(0);
}
