/* *** Audio Record Program *** */
/*      Progrmaed by Masanobu Kimura(mkimura@s3.gsd.mt.nec.co.jp) */
/*      Record Ver 1.0    1994.4.11 */
/*      Rewrite by sas@pat.cl.nec.co.jp on 1995.2.20 */
#include <stdio.h>
#include <sys/stat.h>
#include <sys/audio.h>
#include <signal.h>

#define AUDIODEV "/dev/audio/audio"

void
the_end(
#ifdef __STDC__
	int sig)
#else /* __STDC__ */
	sig)
     int sig;
#endif /* __STDC__ */
{
  signal(sig, SIG_IGN);
  exit(0);
}


int
main(
#ifdef __STDC__
     int argc, char *argv[])
#else /* __STDC__ */
     argc, argv)
     int argc;  char *argv[];
#endif /* __STDC__ */
{
  static FILE *aptr, *fptr;
  struct AU_Type atype;
  int rfrg = 1;
  char data[2];
  if(signal(SIGINT, SIG_IGN) != SIG_IGN)
    signal(SIGINT, the_end);
  if(signal(SIGTERM,SIG_IGN) != SIG_IGN)
    signal(SIGTERM, the_end);

  if(argc == 1) {
    fprintf(stderr, "Usage : record [file] \n");
    exit(0);
  }
  if((fptr = fopen(argv[1], "wb")) == NULL) {
    perror(argv[1]);
    exit(1);
  }
  if((aptr = fopen(AUDIODEV, "rb")) == NULL) {
    perror(AUDIODEV);
    exit(1);
  }
   
  atype.rate = AURATE8_0;
  atype.bit_type = AU_mulaw8;
  atype.channel = AU_MONO;
  if(ioctl(fileno(aptr), AUIOC_SETTYPE, &atype) < 0) {
    perror("ioctl(SETTYPE)");
    exit(2);
  }
  while(rfrg != 0) {
    if((rfrg = read(fileno(aptr), data, 2)) == -1) {
      perror("audioread");
      exit(1);
    } 
    if((write(fileno(fptr), data, 2)) == -1) {
      perror("fileout");
      exit(1);
    }
  }
  fclose(aptr);
  fclose(fptr);
  exit(0);
}
/* *** ---------------------------------------------------------- *** */
