/* ==== finger.c ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@athena.mit.edu
 *
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Tony Nardo of the Johns Hopkins University/Applied Physics Lab.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  1.00 93/08/26 proven
 *      -Pthread redesign of this file.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1989 The Regents of the University of California.\n\
 @(#) Copyright (c) 1993 Chris Provenzano.\n\
 All rights reserved.\n";
#endif /* not lint */

/*
 * Finger prints out information about users.  It is not portable since
 * certain fields (e.g. the full user name, office, and phone numbers) are
 * extracted from the gecos field of the passwd file which other UNIXes
 * may not have or may use for other things.
 *
 * There are currently two output formats; the short format is one line
 * per user and displays login name, tty, login time, real name, idle time,
 * and office location/phone number.  The long format gives the same
 * information (in a more legible format) as well as home directory, shell,
 * mail info, and .plan/.project files.
 */

#include <sys/param.h>
#include <sys/file.h>
#include <pthread.h>
#include <stdio.h>


/*
 * These globals are set initialy and then are only read. 
 * They do not need mutexes.
 */
char myhostname[MAXHOSTNAMELEN + 1];
int lflag =  0, pplan = 0;
time_t now;

main(int argc, char **argv)
{
	char * filename;
	char ch;

	/* getopt variables */
	extern char *optarg;
	extern int optind;

	pthread_init();

	while ((ch = getopt(argc, argv, "f:lps")) != (char)EOF)
		switch(ch) {
		case 'f':
			filename = optarg; 	/* Parse file for list of places to finger */
			break;	
		case 'l':
			lflag = 1;		/* long format */
			break;
		case 'p':
			pplan = 1;		/* don't show .plan/.project */
			break;
		case 's':
			lflag = 0;		/* short format */
			break;
		case '?':
		default:
			(void)fprintf(stderr,
			    "usage: finger [-lps] [-f filename] [login ...]\n");
			exit(1);
		}
	argc -= optind;
	argv += optind;

	(void)gethostname(myhostname, MAXHOSTNAMELEN);
	(void)time(&now);

	/* OK do multi threaded part. */
	if (!*argv) {
		char *arglist[2];

		arglist[0] = myhostname;
		arglist[1] = NULL; 
/* Make it so it connects to the local fingerd server. */
		userlist(1, arglist);
/*		if (entries == 0)
			(void)printf("No one logged on.\n"); */
	} else {
		userlist(argc, argv);
	}
	pthread_exit(NULL);
}

void *netfinger();
userlist(int argc, char **argv)
{
	pthread_t newthread;
	char *index();
	register i;

	/* pull out all network requests */
	for (i = 0; i < argc; i++) {
		if (!index(argv[i], '@')) {
			/* Attach local name to end */
			continue;
		}

		if (pthread_create(&newthread, NULL, netfinger, argv[i])) {
			exit(10);
		}
	}
}
