/* ==== syscall.S ============================================================
 * Copyright (c) 1993 Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Machine dependent syscalls for decstation with r2000/r3000
 *
 *  1.00 93/08/14 proven
 *      -Started coding this file.
 */

#include <copyright.h>
#include <syscall.h>
#include <machine/regdef.h>

/*
 * Initial asm stuff for all functions.
 */
	.text
	.align	2

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value. Eventually I want to load the errno value directly
 * into pthread_run->error but until then ...
 */
machdep_error:
	negu v0, v0				/* Return negative of errno value. */
	j ra

/* ==========================================================================
 * Syscalls already done,
 * Standard		 		BSD sockets
 * read 		=   3	socket		=  97
 * write 		=   4	connect		=  98
 * open 		=   5	accept		=  99
 * close 		=   6	bind		= 104
 * fcntl 		=  92	listen		= 106
 *						getsockopt	= 118
 *						getpeername	= 141
 * ======================================================================= */

/* ==========================================================================
 * machdep_sys_read()
 */
	.globl	machdep_sys_read
	.ent	machdep_sys_read

machdep_sys_read:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_read				/* Load read syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_read

/* ==========================================================================
 * machdep_sys_write()
 */
	.globl	machdep_sys_write
	.ent	machdep_sys_write

machdep_sys_write:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_write				/* Load write syscall # into v0 */
	syscall
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_write

/* ==========================================================================
 * machdep_sys_open()
 */
	.globl	machdep_sys_open
	.ent	machdep_sys_open

machdep_sys_open:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_open				/* Load open syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_open

/* ==========================================================================
 * machdep_sys_close()
 */
	.globl	machdep_sys_close
	.ent	machdep_sys_close

machdep_sys_close:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_close				/* Load close syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_close

/* ==========================================================================
 * machdep_sys_fcntl()
 */
	.globl	machdep_sys_fcntl
	.ent	machdep_sys_fcntl

machdep_sys_fcntl:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_fcntl				/* Load fcntl syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_fcntl

/* ======================================================================= */
/* ==========================================================================
 * machdep_sys_socket()
 */
	.globl	machdep_sys_socket
	.ent	machdep_sys_socket

machdep_sys_socket:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_socket			/* Load socket syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_socket

/* ==========================================================================
 * machdep_sys_connect()
 */
	.globl	machdep_sys_connect
	.ent	machdep_sys_connect

machdep_sys_connect:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_connect			/* Load connect syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_connect

/* ==========================================================================
 * machdep_sys_accept()
 */
	.globl	machdep_sys_accept
	.ent	machdep_sys_accept

machdep_sys_accept:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_accept			/* Load accept syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_accept

/* ==========================================================================
 * machdep_sys_bind()
 */
	.globl	machdep_sys_bind
	.ent	machdep_sys_bind

machdep_sys_bind:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_bind				/* Load bind syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_bind

/* ==========================================================================
 * machdep_sys_listen()
 */
	.globl	machdep_sys_listen
	.ent	machdep_sys_listen

machdep_sys_listen:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_listen			/* Load listen syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_listen

/* ==========================================================================
 * machdep_sys_getsockopt()
 */
	.globl	machdep_sys_getsockopt
	.ent	machdep_sys_getsockopt

machdep_sys_getsockopt:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_getsockopt		/* Load getsockopt syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_getsockopt

/* ==========================================================================
 * machdep_sys_getpeername()
 */
	.globl	machdep_sys_getpeername
	.ent	machdep_sys_getpeername

machdep_sys_getpeername:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_getpeername		/* Load getpeername syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_getpeername

/* ==========================================================================
 * Other important asm routines.
 * ======================================================================= */
/* ==========================================================================
 * fake_setjmp()
 */
	.globl	fake_setjmp
	.ent	fake_setjmp

fake_setjmp:

	.frame sp,0,ra				/* No frame, return address in ra */

								/* Save all the important registers */
	sw ra,8(a0)
	sw gp,124(a0)
	sw sp,128(a0)
	sw s0,76(a0)
								/* More registers needed. */
	j ra

	.end	fake_longjmp

/* ==========================================================================
 * machdep_sys_longjmp()
 */
	.globl	machdep_sys_longjmp
	.ent	machdep_sys_longjmp

machdep_sys_longjmp:

	.frame sp,0,ra				/* No frame, return address in ra */
	li a1,1						/* Load 1 into reg a1 */
	sw a1, 20(a0);				/* Load a1 into address a0 + 20 */
	li v0,SYS_sigreturn			/* Load sigreturn syscall # into v0 */
	syscall						/* Do syscall to do longjmp */
	j ra

	.end	machdep_sys_longjmp
