/*
 * Copyright (c) 1985, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *	  must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)gethostbyaddr.c	6.45 (Berkeley) 2/24/91";*/
static char *rcsid = "$Id: gethostbyaddr.c,v 1.5 1995/01/06 14:34:12 ghudson Exp $";
#endif /* LIBC_SCCS and not lint */


#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <netinet/in.h>
#include <resolv.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "res_internal.h"

static struct hostent *file_find(const char *addr, int len, int type,
								 struct res_data *data,
								 struct hostent_answer *result);

struct hostent *gethostbyaddr(const char *addr, int len, int type)
{
	struct res_data *data = _res_init();

	return (data) ? gethostbyaddr_r(addr, len, type, &data->host_answer)
		: NULL;
}

struct hostent *gethostbyaddr_r(const char *addr, int len, int type,
								struct hostent_answer *result)
{
	struct res_data *data;
	querybuf buf;
	char lookups[MAXDNSLUS], qbuf[MAXDNAME];
	struct hostent *hp;
	int n, i;

	data = _res_init();
	if (!data)
		return NULL;

	if (type != AF_INET)
		return NULL;
	sprintf(qbuf, "%u.%u.%u.%u.in-addr.arpa",
			(unsigned)addr[3] & 0xff, (unsigned)addr[2] & 0xff,
			(unsigned)addr[1] & 0xff, (unsigned)addr[0] & 0xff);

	memcpy(lookups, data->state.lookups, sizeof(lookups));
	if (*lookups == 0)
		strncpy(lookups, "bf", sizeof(lookups));

	hp = NULL;
	for (i = 0; i < MAXDNSLUS && hp == NULL && lookups[i]; i++) {
		switch (lookups[i]) {
		  case	'b':
			n = res_query(qbuf, C_IN, T_PTR, (char *)&buf, sizeof(buf));
			if (n < 0)
				break;
			hp = _res_parse_answer(&buf, n, 1, result, data);
			if (hp == NULL)
				break;
			hp->h_addrtype = type;
			hp->h_length = len;
			hp->h_addr_list[0] = (char *) &result->host_addr;
			hp->h_addr_list[1] = NULL;
			result->host_addr = *(struct in_addr *)addr;
			break;

		  case 'f':
			hp = file_find(addr, len, type, data, result);
			break;
		}
	}

	return hp;
}

static struct hostent *file_find(const char *addr, int len, int type,
								 struct res_data *data,
								 struct hostent_answer *result)
{
	struct hostent *entry;
	char **alias;
	FILE *fp = NULL;

	sethostent_r(&fp);
	while (1) {

		/* Get a host entry friom the file. */
		entry = gethostent_r(result, &fp);
		if (!entry)
			break;

		/* Check it against the given address. */
		if (entry->h_addrtype == type && memcmp(entry->h_addr, addr, len) == 0)
			break;
	}
	endhostent_r(&fp);

	if (!entry)
		data->errval = HOST_NOT_FOUND;
	return entry;
}

