/* ==== test_fork.c ============================================================
 * Copyright (c) 1994 by Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Test fork() and dup2() calls.
 *
 *  1.00 94/04/29 proven
 *      -Started coding this file.
 */

#define PTHREAD_KERNEL
#include <pthread.h>
#include <stdio.h>
#include <fcntl.h>

main()
{
	pthread_t thread;
	int flags;

	pthread_init(); 

	printf("This output is necessary to set the stdout fd to O_NDELAY\n");

	switch(fork()) {
	case OK:
		exit(OK);
		break;
	case NOTOK:
		printf("Error: fork\n");
		break;
	default:
		if ((flags = machdep_sys_fcntl(1, F_GETFL, NULL)) >= OK) {
			if (flags & __FD_NONBLOCK) {
				printf("Error: the stdout fd was not set to BLOCKING\n");
				break;
			}
			printf("The stdout fd was set to BLOCKING\n");
			flags = machdep_sys_fcntl(1, F_GETFL, NULL);
			if (flags & __FD_NONBLOCK) {
				printf("The stdout fd was reset to O_NDELAY\n");
			} else {
				printf("Error: the stdout fd was not reset\n");
			}
		}
		break;
	}
	pthread_exit(NULL);
	PANIC();
}
