/*
 * Copyright (c) 1982,1985,1986,1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)socket.h	7.13 (Berkeley) 4/20/91
 */

#ifndef _SOCKET_H_
#define	_SOCKET_H_

/*
 * Definitions related to sockets: types, address families, options.
 */

/*
 * Types
 */
#define	SOCK_STREAM		2			/* stream socket */
#define	SOCK_DGRAM		1			/* datagram socket */
#define	SOCK_RAW		4			/* raw-protocol interface */
#define	SOCK_RDM		5			/* reliably-delivered message */
#define	SOCK_SEQPACKET	6			/* sequenced packet stream */

/*
 * Option flags per-socket.
 */
#define	SO_DEBUG		0x0001		/* turn on debugging info recording */
#define	SO_ACCEPTCONN	0x0002		/* socket has had listen() */
#define	SO_REUSEADDR	0x0004		/* allow local address reuse */
#define	SO_KEEPALIVE	0x0008		/* keep connections alive */
#define	SO_DONTROUTE	0x0010		/* just use interface addresses */
#define	SO_BROADCAST	0x0020		/* permit sending of broadcast msgs */
#define	SO_USELOOPBACK	0x0040		/* bypass hardware when possible */
#define	SO_LINGER		0x0080		/* linger on close if data present */
#define	SO_OOBINLINE	0x0100		/* leave received OOB data in line */

/*
 * Additional options, not kept in so_options.
 */
#define SO_SNDBUF		0x1001		/* send buffer size */
#define SO_RCVBUF		0x1002		/* receive buffer size */
#define SO_SNDLOWAT		0x1003		/* send low-water mark */
#define SO_RCVLOWAT		0x1004		/* receive low-water mark */
#define SO_SNDTIMEO		0x1005		/* send timeout */
#define SO_RCVTIMEO		0x1006		/* receive timeout */
#define	SO_ERROR		0x1007		/* get error status and clear */
#define	SO_TYPE			0x1008		/* get socket type */
#define SO_PROTOTYPE    0x1009      /* get/set protocol type */

/*
 * Structure used for manipulating linger option.
 */
struct	linger {
	int	l_onoff;					/* option on/off */
	int	l_linger;					/* linger time */
};

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define	SOL_SOCKET	0xffff			/* options for socket level */

/*
 * Address families.
 */
#define	AF_UNSPEC		0			/* unspecified */
#define	AF_UNIX			1			/* local to host (pipes, portals) */
#define	AF_INET			2			/* internetwork: UDP, TCP, etc. */
#define	AF_IMPLINK		3			/* arpanet imp addresses */
#define	AF_PUP			4			/* pup protocols: e.g. BSP */
#define	AF_CHAOS		5			/* mit CHAOS protocols */
#define	AF_NS			6			/* XEROX NS protocols */
#define AF_NBS     		7       	/* nbs protocols */
#define	AF_ECMA			8			/* european computer manufacturers */
#define	AF_DATAKIT		9			/* datakit protocols */
#define	AF_CCITT		10			/* CCITT protocols, X.25 etc */
#define	AF_SNA			11			/* IBM SNA */
#define AF_DECnet		12			/* DECnet */
#define AF_DLI			13			/* DEC Direct data link interface */
#define AF_LAT			14			/* LAT */
#define	AF_HYLINK		15			/* NSC Hyperchannel */
#define	AF_APPLETALK	16			/* Apple Talk */
#define AF_NIT   	   	17      	/* Network Interface Tap */
#define AF_802      	18      	/* IEEE 802.2, also ISO 8802 */
#define	AF_ISO			19			/* ISO protocols */
#define	AF_OSI			AF_ISO
#define AF_X25      	20      	/* CCITT X.25 in particular */
#define	AF_OSINET		21
#define	AF_GOSIP		22
#define	AF_MAX			22

/* Not supported by solaris */
/* #define	AF_ROUTE		17			/* Internal Routing Protocol */
/* #define	AF_LINK			18			/* Link layer interface */
/* #define	pseudo_AF_XTP	19			/* eXpress Transfer Protocol (no AF) */


/*
 * Structure used by kernel to store most
 * addresses.
 */
struct sockaddr {
	u_short	sa_family;			/* address family */
	char	sa_data[14];		/* actually longer; address value */
};

/*
 * Structure used by kernel to pass protocol
 * information in raw sockets.
 */
struct sockproto {
	u_short	sp_family;			/* address family */
	u_short	sp_protocol;		/* protocol */
};

/*
 * Protocol families, same as address families for now.
 */
#define	PF_UNSPEC		AF_UNSPEC
#define	PF_UNIX			AF_UNIX
#define	PF_INET			AF_INET
#define	PF_IMPLINK		AF_IMPLINK
#define	PF_PUP			AF_PUP
#define	PF_CHAOS		AF_CHAOS
#define	PF_NS			AF_NS
#define	PF_NBS			AF_NBS
#define	PF_ECMA			AF_ECMA
#define	PF_DATAKIT		AF_DATAKIT
#define	PF_CCITT		AF_CCITT
#define	PF_SNA			AF_SNA
#define PF_DECnet		AF_DECnet
#define PF_DLI			AF_DLI
#define PF_LAT			AF_LAT
#define	PF_HYLINK		AF_HYLINK
#define	PF_APPLETALK	AF_APPLETALK
#define	PF_NIT			AF_NIT
#define	PF_802			AF_802
#define	PF_ISO			AF_ISO
#define	PF_OSI			AF_ISO
#define	PF_X25			AF_X25
#define	PF_OSINET		AF_OSINET
#define	PF_GOSIP		AF_GOSIP
#define	PF_MAX			AF_MAX

/* #define	PF_ROUTE	AF_ROUTE */
/* #define	PF_LINK		AF_LINK */
/* #define	PF_XTP		pseudo_AF_XTP	/* really just proto family, no AF */

/*
 * Maximum queue length specifiable by listen.
 */
#define	SOMAXCONN		5

/*
 * Message header for recvmsg and sendmsg calls.
 * Used value-result for recvmsg, value only for sendmsg.
 */
struct msghdr {
	caddr_t	msg_name;		/* optional address */
	u_int	msg_namelen;		/* size of address */
	struct	iovec *msg_iov;		/* scatter/gather array */
	u_int	msg_iovlen;		/* # elements in msg_iov */
	caddr_t msg_accrights;      /* access rights sent/received */
    int msg_accrightslen;
};

#define MSG_MAXIOVLEN   16

#define	MSG_OOB			0x1		/* process out-of-band data */
#define	MSG_PEEK		0x2		/* peek at incoming message */
#define	MSG_DONTROUTE	0x4		/* send without using routing tables */

/* #define	MSG_EOR		0x8			 data completes record */
/* #define	MSG_TRUNC	0x10		 data discarded before delivery */
/* #define	MSG_CTRUNC	0x20		 control data lost before delivery */
/* #define	MSG_WAITALL	0x40		 wait for full request or error */

/*
 * Header for ancillary data objects in msg_control buffer.
 * Used for additional information with/about a datagram
 * not expressible by flags.  The format is a sequence
 * of message elements headed by cmsghdr structures.
 */
struct cmsghdr {
	u_int	cmsg_len;		/* data byte count, including hdr */
	int	cmsg_level;		/* originating protocol */
	int	cmsg_type;		/* protocol-specific type */
/* followed by	u_char  cmsg_data[]; */
};

/* given pointer to struct adatahdr, return pointer to data */
#define	CMSG_DATA(cmsg)		((u_char *)((cmsg) + 1))

/* given pointer to struct adatahdr, return pointer to next adatahdr */
#define	CMSG_NXTHDR(mhdr, cmsg)	\
	(((caddr_t)(cmsg) + (cmsg)->cmsg_len + sizeof(struct cmsghdr) > \
	    (mhdr)->msg_control + (mhdr)->msg_controllen) ? \
	    (struct cmsghdr *)NULL : \
	    (struct cmsghdr *)((caddr_t)(cmsg) + ALIGN((cmsg)->cmsg_len)))

#define	CMSG_FIRSTHDR(mhdr)	((struct cmsghdr *)(mhdr)->msg_control)

/* "Socket"-level control message types: */
#define	SCM_RIGHTS	0x01		/* access rights (array of int) */

/*
 * 4.3 compat sockaddr, move to compat file later
 */
struct osockaddr {
	u_short	sa_family;		/* address family */
	char	sa_data[14];		/* up to 14 bytes of direct address */
};

#define SYS_socketcall			83

#define SO_ACCEPT   			1
#define SO_BIND     			2
#define SO_CONNECT  			3
#define SO_GETPEERNAME 		 	4
#define SO_GETSOCKNAME 		 	5
#define SO_GETSOCKOPT  		 	6
#define SO_LISTEN   			7
#define SO_RECV     			8
#define SO_RECVFROM 			9
#define SO_SEND     			10
#define SO_SENDTO   			11
#define SO_SETSOCKOPT  		 	12
#define SO_SHUTDOWN 			13
#define SO_SOCKET   			14
#define SO_SOCKPOLL 			15
#define SO_GETIPDOMAIN 		 	16
#define SO_SETIPDOMAIN 		 	17
#define SO_ADJTIME  			18

#include <sys/cdefs.h>

__BEGIN_DECLS
int	accept __P((int, struct sockaddr *, int *));
int	bind __P((int, const struct sockaddr *, int));
int	connect __P((int, const struct sockaddr *, int));
int	getpeername __P((int, struct sockaddr *, int *));
int	getsockname __P((int, struct sockaddr *, int *));
int	getsockopt __P((int, int, int, void *, int *));
int	listen __P((int, int));
/* original definitions
int	recv __P((int, void *, int, int));
int	recvfrom __P((int, void *, int, int,
		struct sockaddr *, int *));
int	recvmsg __P((int, struct msghdr *, int));
int	send __P((int, const void *, int, int));
int	sendto __P((int, const void *, int, int, const struct sockaddr *, int));
int	sendmsg __P((int, const struct msghdr *, int));
*/
ssize_t	recv __P((int, void *, size_t, int));
ssize_t	recvfrom __P((int, void *, size_t, int,
		struct sockaddr *, int *));
ssize_t	recvmsg __P((int, struct msghdr *, int));
ssize_t	send __P((int, const void *, size_t, int));
ssize_t	sendto __P((int, const void *, size_t, int,
		const struct sockaddr *, int));
ssize_t	sendmsg __P((int, const struct msghdr *, int));
int	setsockopt __P((int, int, int, const void *, int));
int	shutdown __P((int, int));
int	socket __P((int, int, int));
int	socketpair __P((int, int, int, int *));
__END_DECLS

#endif /* !_SOCKET_H_ */
