// This is -*- c++ -*- code

#ifndef __CHESS_CAPTURE_MOVE_H__
#define __CHESS_CAPTURE_MOVE_H__

#include "move.h"
#include "chess_display_board.h"
#include <typeinfo.h>

class chess_capture_move : public move {
    
    // Overview: an move passed between  board and player and
    // chess game that results in the capture of a piece.  A
    // chess_capture_move is an immutable stack/heap abstraction. 

  public:
    
    // Constructors and Destructors:

    chess_capture_move (int from_x, int from_y, int to_x, int to_y,
			chess_display_board::chess_piece piece,
			chess_display_board::color c,
			bool promotion);
    // Requires: 0 <= from_x, from_y, to_x, to_y <=7.  That the square
    // on the board this move belongs to at from_x,from_y is not
    // empty.
    // Effects: creates an new chess_capture_move.
    
    chess_capture_move (const chess_capture_move &m);
    // Effects: copies a chess_move.

    chess_capture_move(int x1, int y1, int x2, int y2, chess_display_board *brd);
    // Effects: creates a chess_capture_move appropriate for moving
    // from x1, y1 to x2, y2 on the given board.
    
    virtual ~chess_capture_move();
    // Frees any state associated with chess_move.
    
    // Methods:

    virtual void display(extensions *ext, ostream &body);
    // Effects: returns an html representation of this move for inclusion
    // in a move list.  The headers in extensions (if extensions is non-null)
    // can be used to determine the capabilities of the web client.
    // Effects:  Return a textual representation of the move for inclusion
    // in a move list.
    
    virtual bool operator == (move &m);
    // Effects: returns true if two moves are equal, else returns
    // false.  Move equality means that the effect of applying one
    // move to any board will be indistinguishable from the effect of
    // applying the other move to the same board.

    virtual chess_display_board::path get_path() const;
    // Effects: reurns the path of this move.
    
    virtual move * copy();
    //Effects: returns a copy of this such that
    // this->copy() == this.

    chess_display_board::chess_piece get_piece_taken() const;
    // Effects: Returns the piece taken.

    chess_display_board::color get_color_taken() const;
    // Effects: Returns the color of the piece taken.
    
    bool was_promotion() const;
    // Effects: Returns true if this move resulted in the piece being
    // promoted, else returns false.

    static typeinfo_t typeinfo;
    
    virtual void * force ( typeinfo_t &type);
    
    chess_capture_move & operator = (const chess_capture_move & m );
    // Modifies: this
    // Effects: this becomes m


    chess_capture_move ();
    // Effects: returns a new chess capture move.

  private:

    chess_display_board::path p;
    chess_display_board::color c;
    chess_display_board::chess_piece piecetaken;
    bool promoted;
};

inline chess_capture_move &chess_capture_move::operator = 
(const chess_capture_move &m) {
promoted = m.promoted;
c = m.c;
piecetaken = m.piecetaken;
p = m.p;

    return *this;
}

inline chess_capture_move::chess_capture_move() {}

inline chess_capture_move::~chess_capture_move() {}

inline chess_display_board::path chess_capture_move::get_path() const{
    return p;
}

inline chess_display_board::chess_piece chess_capture_move::get_piece_taken() const {
    return piecetaken;
}
inline chess_display_board::color chess_capture_move::get_color_taken() const {
    return c;
}

inline bool chess_capture_move::was_promotion() const{
    return promoted;
}

char piecetoc(chess_display_board::chess_piece p,
	      chess_display_board::color pc);
	      
#endif
