//  This is -*- c++ -*- code
// $Id: machine_player.h,v 1.9 1995/12/11 18:43:37 hartmans Exp $


#ifndef __MACHINE_PLAYER_H__
#define __MACHINE_PLAYER_H__

#include <6170.h>
#include "board.h"
#include "player.h"
class move;

class http_response;

class machine_player : public player {
    // Overview: A machine_player is an automated  participant in a game, 
    //played upon a board.
public:
    // Constructors:

    machine_player(long total_time, bool can_i_go);
    // Checks: total_time >= 0;
    // Effects:  Creates a new machine_player, not associated with
    // any game which will have have up total_time seconds to complete
    // all moves. Assigns a name to the new machine_player. 
    // Methods:
    virtual void display(extensions *ext, ostream &body) const;

    virtual http_response *get(string request, extensions *ext);

    virtual void you_moved(move &m);

    virtual void opponent_moved (move &m, int p);

    virtual void state_changed(void);

protected:
    virtual void associate(game *g);
    
private:
    void try_move(void);
    // Try to make a move now.

    struct mnode;
    struct mgnode {
      move_generator *mg;
      int mg_index;
      mnode *mn;
      mgnode *next;
    };
    struct mnode {
      move *nmove;
      board::value nval;
      mgnode *nnode;
      mnode *next;
    };
    void try_simple(void);
    void try_alpha(void);
    void  do_level(mnode *curr_mnode, board *cbrd, 
		   board::value currval, board::value &bestval, 
		   board::value maxval, move *&bestmove, 
		   move *topmove, bool istop);
    bool descend(mnode *curr_mnode, board *curr_board, 
		 int this_depth, board::value currval, 
		 board::value &bval, board::value mval, 
		 move *&bmove, bool istop, move *topmove,
		 long start_time, long time_to_move);
    // Specific move strategies.

    machine_player();
    // Disable default constructor

    void operator= (machine_player &);
    // Disable equality operator

    bool can_go;
    // Can I go immediately, or must I wait to be allowed to take
    // my turn?
    int my_index;
    // My player index
};

#endif
