#include "ps5/dir_node.h"
#include "ps5/url_ops.h"
#include "ps5/simple_response.h"
#include "ps5/error_response.h"

#include "map.h"

dir_node::dir_node(string name) {
    mappings = new map<string, web_node *>(10);
    self_name = name;
}

bool dir_node::add(string name, web_node *child) {
    if (mappings->contains(name)) return false;
    mappings->add(name, child);
    mappings->allowAutoResize();
    return true;
}

bool dir_node::remove(string name) {
    web_node *it;
    return mappings->remove(name, it);
}

http_response *dir_node::get(string request, extensions *ext) {
    string path = extract_pathname(request);
    if (path == "") return get_self(extract_query(request), ext);
    string first = first_component(path);
    web_node *child;
    if (!mappings->find(first, child)) 
	return new error_response(http_response::NOT_FOUND, 
				  string("Component not found: ") + first);
    return child->get(rest_components(request), ext);
}

http_response *dir_node::get_self(string request, extensions *ext) {
    string res = "<head><title>Directory Node</title>\n";
    res = res + "<body><h1>Directory:</h1>\n <ul>\n";
    generator<string> *g = mappings->keys();
    string child;
    while (g->get(child))
	res = res + "<li><a href=\"" + self_name + "/" + child + "\">" + child + "</a>\n";
    res = res + "</ul>\n";
    return new simple_response(res, true);
}

class dirgen : public generator<web_node *> {
public:
    dirgen(dir_node *d) {
	g = d->mappings->mappings();
    }
    bool get(web_node *&w) {
	string s;
	if (g->get(s)) {
	    w = g->value();
	    return true;
	} else {
	    return false;
	}
    }
private:
    hash_generator<string, web_node *> *g;
};

generator<web_node *> *dir_node::descendents() {
    return new dirgen(this);
}


string dir_node::base_uri() const {
    return self_name;
}
