#include "ps5/http_response.h"

int http_response::code() {
    return OK;
}

void http_response::headers(ostream &o) {
    o << "Server: MIT 6.170 HTTP server code\n"
         "MIME-version: 1.0\n"
         "Content-type: " << content_type() << '\n';
    int length;
    if (body_length(length))
	o << "Content-length: " << length << '\n';
}

void http_response::send(ostream &o) {
    int result = code();
    o << "HTTP/1.0 " << result << " " << result_description(result) << '\n';
    headers(o);
    o << "\r\n"; // CRLF
    body(o);
}

string http_response::content_type() {
    return "text/html";
}

void http_response::body(ostream &o) {
    o << "<head><title>Default Response</title>\n"
         "<body>This is the default HTTP response\n";
}

bool http_response::body_length(int &length) {
    return false;
}


string result_description(int code) {
    switch(code) {
	case http_response::OK: return "Ok";
    	case http_response::ACCEPTED: return "Accepted";
	case http_response::NO_RESPONSE: return "No Response";
	case http_response::MOVED: return "Moved";
	case http_response::BAD_REQUEST: return "Bad Request";
	case http_response::UNAUTHORIZED: return "Unauthorized";
	case http_response::NOT_FOUND: return "Not Found";
	case http_response::INTERNAL_ERROR: return "Internal Error";
	case http_response::NOT_IMPLEMENTED: return "Not Implemented";
	case http_response::OVERLOADED: return "Server Overloaded";
	default: return "Unknown Result Code";
    }
}
