#include <string.h>
#include <unistd.h>
#include <fstream.h>

#include "http_handler.h"

void http_handler(sockstream &s, web_server *ws) {

    // parse http request of form "GET /relative-path blah"
    bool ok = true; // whether http request is well formed

    string http_method, http_path;
    ok = ok && (s.in() >> http_method);
    ok = ok && (http_method == "GET");
    ok = ok && (s.in() >> http_path);
    ok = ok && (http_path[0] == '/');

    if (ok) {
	string request = http_path.substring(1, http_path.length()-1);
	s.out() << (ws->get(request)) << endl; // endl required to flush
    } else {
	s.out() << "HTTP/1.0 400 Bad Request\n";
    }
    s.out().flush();
}
