#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

#include "sockstream.h"
#include "server.h"
#include "http_handler.h"
#include "path_server.h"
#include <6170.h>

int main(int argc, char* argv[]) {
    if (argc != 2) {
	cout << "Usage: " << argv[0] << " <port-number> \n";
	exit(1);
    }
    int port = atoi(argv[1]);
    if (errno) {
	cout << "port-number non-integral";
	exit(1);
    }

    server *s = new server(port);
    path_server *ps = new path_server();
    ps->path_db("big-map");
    
    for(;;) {
	sockstream conn = s->accept();
	http_handler(conn, ps);
	conn.close();
    }
    s->close();
    return 0;
}
