#include "path_server.h"

static bool eqs(string a, string b){
    return (a == b);
}

string ftostr(float a){
    char temp[6];
    sprintf(temp, "%.2f",a);
    string s(temp);
    return s;
}

string spaceify(string a){
    string b;
    int i;
    
    for (i=0; i < a.length(); i++){
	if (a[i] == '_') 
	    b = b.append(' ');
	else
	    b = b.append(a[i]);
    }
    return b;
}

path_server::path_server(){
    paths = new table<string, dest_info>(eqs);
    d = new array<floatarray>(100);
    routes = new array<rinfo>(100);
}    

string path_server::get(string request) {
    int i;
    int len = request.length();
    for (i = 0; i < len; i++) 
	if (request[i] == '?') break;
    
    if (i == len) return "bad request syntax";
    
    string command = request.substring(0, i);
    string arg = request.substring(i+1, len-i-1);

    len = arg.length();
    for (i = 0; i < len; i++) 
	if (arg[i] == '=') break;
    if (i != len)
	arg = arg.substring(i+1, len-i-1);

    if (command == "echo") 
	return echo(arg);
    else if (command == "path_db")
	return path_db(arg);
    else if (command == "path_query")
	return path_query(arg);

    return "command not implemented";
}


string path_server::path_db(string filename) {
    string from, to, direction, mid;
    int j, n, x, y, V;
    float distance;
    ifstream infile = input_file(filename); 
    floatarray dx, dy, dj;
    float dyx, djy, djx;
    rinfo rx, ry, rj;
    string current, base;
    dest_info temptable;
    path_info temp;
    string tmp;

    if (!infile) {
	return "unreadable file";
    } 
    
    while ((infile.good()) &&(infile >> from >> to >> distance >> direction)){
	int s = infile.rdstate();
	if (s & ios::badbit)
	    return "bad format";
		
	path_info temp;
	dest_info dest;
	temp.dir = direction;
	temp.dist = distance;

	if (distance <= 0)
	    return "bad format";
	
	if (paths->lookup(from, dest)) {
	    if(dest->lookup(to, temp)) {
		if (temp.dist > distance) {
		    temp.dist = distance;
		    temp.dir = direction;
		}
	    }
	    else
		dest->insert(to, temp);
	}
	else {
	    dest = new table<string, path_info >(eqs);
	    dest->insert(to, temp);
	    paths->insert(from, dest);
	}
    }
    if (!infile.eof)
	return "bad format";
    
    V = paths->length();
    
    for (x=0; x < V; x++) {
	d->append(new array<float>(V+1));
	routes->append(new array<string>(V+1));
    }
    
    x =0;
    generator<string> *gn = paths->keys();
    while(gn->get(base)) {
	paths->lookup(base, temptable);
	dx = d->fetch(x);
	rx = routes->fetch(x);
	
	generator<string> *gn2 = paths->keys();
	n=0;
	while(gn2->get(current)) {
	    if (temptable->lookup(current, temp)){
		dx->append(temp.dist);
		rx->append(string("go ") + temp.dir + string(" ") + 
			   ftostr(temp.dist)+string(" miles to ")+
			   current+string("\n"));
	    }
	    else if (n==x){
		dx->append(-1);
		rx->append(tmp);
	    }
	    else {
		dx->append(0);
		rx->append(tmp);
	    }
	    n++;
	}
	x++;
    }


    for (y=0; y < V; y++) {
	dy = d->fetch(y);
	ry = routes->fetch(y);
	for (x=0; x < V; x++){
	    dyx = dy->fetch(x);
	    if (dyx > 0)
		for (j=0; j < V; j++) { 
		    dj = d->fetch(j);
		    rj = routes->fetch(j);
		    djy = dj->fetch(y);
		    djx = dj->fetch(x);
		    if (djy > 0)
			if ((!djx) ||  (dyx+djy < djx)){
			    dj->store(x,dyx + djy);
			    
			    tmp= "";
			    from = paths->get_key(j);
			    mid= paths->get_key(y);
			    to = paths->get_key(x);
			    paths->lookup(from,temptable);
			    if(!temptable->lookup(mid, temp)){
				tmp = rj->fetch(y);
			    }
			    else
				tmp =tmp+string("go ")+temp.dir+string(" ") + 
				    ftostr(djy)+string(" miles to ")+mid+"\n";
			    paths->lookup(mid,temptable);
			    if(!temptable->lookup(to, temp)){
				tmp = ry->fetch(x);
			    }
			    else
				tmp=tmp+string("go ")+temp.dir+string(" ")
				    +ftostr(dyx)+string(" miles to ")
				    +to+"\n";
			    rj->store(x, tmp);
			}
		}
	}
    }
    return "ok";
}

string path_server::path_query(string query){
    int i;
    int len = query.length();
    string returnval;
    int yindx, xindx;
    floatarray dy;
    float dyx;
    rinfo tmp;

    for (i = 0; i < len; i++)
	if ((query[i] == ',') || (query[i] == '%')) break;
    if (i == len) return "bad query";

    string from = query.substring(0, i);
    string to;
    if (query[i] == '%')
	to= query.substring(i+3,len-i-1);
    else
	to = query.substring(i+1, len-i-1);
    
    xindx = yindx = -1;
    for(i=0; i < paths->length(); i++){
	if(paths->get_key(i) == from)
	    yindx = i;
	if(paths->get_key(i) == to)
	    xindx = i;
    }
    
    if ((xindx==-1) ||(yindx==-1)) {
	returnval =string("no path from ")+from+string(" to ")+to+string("\n");
	return returnval;	
    }
    
    dy= d->fetch(yindx);
    dyx = dy->fetch(xindx);

    if (dyx == 0){
	returnval =string("no path from ")+from+string(" to ")+to+string("\n");
	return returnval;	
    }
    if (dyx == -1)
	return "you are already there\n";
        
    tmp = routes->fetch(yindx);
    return spaceify(tmp->fetch(xindx))+string("stop\n");
}


