.\"
.\" %nmhwarning%
.\" $Id: nmh.man,v 1.1.1.1 1999-02-07 18:14:20 danw Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.if '\*(ZZ'-man' \{\
.TH NMH %manext1% MH.6.8 [%nmhversion%]
.SH NAME
nmh \- new MH message system
.SH SYNOPSIS
.in +.5i
.ti -.5i
any \fInmh\fR command
.in -.5i
.SH DESCRIPTION
\fInmh\fR is the name of a powerful message handling system.  Rather than
being a single comprehensive program, \fInmh\fR consists of a collection
of fairly simple single-purpose programs to send, retrieve, save,
and manipulate messages.

Unlike most mail clients in UNIX, \fInmh\fR is not a closed system which
must be explicitly run, then exited when you wish to return to the shell.
You may freely intersperse \fInmh\fR commands with other shell commands,
allowing you to read and answer your mail while you have (for example)
a compilation running, or search for a file or run programs as needed
to find the answer to someone's question before answering their mail.

The rest of this manual entry is a quick tutorial which will teach you
the basics of \fInmh\fR.  You should read the manual entries for the
individual programs for complete documentation.

To get started using \fInmh\fR, put the directory \fB%bindir%\fR on your
\fB$PATH\fR.  This is best done in one of the files: \fB\&.profile\fR,
\fB\&.login\fR, or \fB\&.cshrc\fR in your home directory.  (Check the
manual entry for the shell you use, in case you don't know how to
do this.)  Run the \fIinc\fR command.  If you've never used \fInmh\fR
before, it will create the necessary default files and directories after
asking you if you wish it to do so.

\fIinc\fR moves mail from your system maildrop into your \fInmh\fR
`+inbox' folder, breaking it up into separate files and converting it
to \fInmh\fR format as it goes.  It prints one line for each message it
processes, containing the from field, the subject field and as much of
the first line of the message as will fit.  It leaves the first message
it processes as your current message.  You'll need to run \fIinc\fR each
time you wish to incorporate new mail into your \fInmh\fR file.

\fIscan\fR prints a list of the messages in your current folder.

The commands: \fIshow\fR, \fInext\fR, and \fIprev\fR are used to read
specific messages from the current folder.  \fIshow\fR displays the
current message, or a specific message, which may be specified by its
number, which you pass as an argument to \fIshow\fR.  \fInext\fR and
\fIprev\fR display, respectively, the message numerically after or before
the current message.  In all cases, the message displayed becomes the
current message.  If there is no current message, \fIshow\fR may be
called with an argument, or \fInext\fR may be used to advance to the
first message.

\fIrmm\fR (remove message) deletes the current message.  It may be called
with message numbers passed as arguments, to delete specific messages.

\fIrepl\fR is used to respond to the current message (by default).
It places you in the editor with a prototype response form.  While you're
in the editor, you may peruse the item you're responding to by reading
the file \fB@\fR.  After completing your response, type \fBl\fR to list
(review) it, or \fBs\fR to send it.

\fIcomp\fR allows you to compose a message by putting you in the editor
on a prototype message form, and then lets you send it.

All the \fInmh\fR commands may be run with the single argument: `\-help',
which causes them to print a list of the arguments they may be invoked
with and then exit.

All the \fInmh\fR commands may be run with the single argument:
`\-version', which cause them to print the version number of the \fInmh\fR
distribution, and then exit.

Commands which take a message number as an argument (\fIscan\fR,
\fIshow\fR, \fIrepl\fR, ...)  also take one of the words: \fIfirst\fR,
\fIprev\fR, \fIcur\fR, \fInext\fR, or \fIlast\fR to indicate
(respectively) the first, previous, current, next, or last message in
the current folder (assuming they are defined).

Commands which take a range of message numbers (\fIrmm\fR, \fIscan\fR,
\fIshow\fR, ...)  also take any of the abbreviations:
.sp
.in +5
.ti -3
.I <num1>-<num2>
- Indicates all messages in the range <num1> to <num2>, inclusive. The range
.B must
be nonempty.
.sp
.ti -3
.I <num>:+N
.ti -3
.I <num>:-N
- Up to
.I N
messages beginning with (or ending with) message
.I num.
.I Num
may be any of the pre-defined symbols:
.I first, prev, cur, next
or
.I last.
.sp
.ti -3
.I first:N
.ti -3
.I prev:N
.ti -3
.I next:N
.ti -3
.I last:N
- The first, previous, next or last
.I N
messages, if they exist.
.in -5

There are many other possibilities such as creating multiple folders
for different topics, and automatically refiling messages according to
subject, source, destination, or content.  These are beyond the scope
of this manual entry.

Following is a list of all the \fInmh\fR commands:
.\}

.nf
.in .5i
.ta 1.5i
^ali (1)~^\- list mail aliases
^anno (1)~^\- annotate messages
^burst (1)~^\- explode digests into messages
^comp (1)~^\- compose a message 
^dist (1)~^\- redistribute a message to additional addresses
^flist (1)~^\- list folders that contain messages in given sequence(s)
^flists (1)~^\- list all folders that contain messages in given sequence(s)
^folder (1)~^\- set/list current folder/message
^folders (1)~^\- list all folders
^forw (1)~^\- forward messages
^inc (1)~^\- incorporate new mail
^mark (1)~^\- mark messages
^mhbuild (1)~^\- translate MIME composition draft
^mhl (1)~^\- produce formatted listings of nmh messages
^mhlist (1)~^\- list information about content of MIME messages
^mhmail (1)~^\- send or read mail
^mhn (1)~^\- display/list/store/cache MIME messages
^mhparam (1)~^\- print nmh profile components
^mhpath (1)~^\- print full pathnames of nmh messages and folders
^mhshow (1)~^\- display MIME messages
^mhstore (1)~^\- store contents of MIME messages into files
^msgchk (1)~^\- check for messages
^msh (1)~^\- nmh shell (and BBoard reader)
^next (1)~^\- show the next message
^packf (1)~^\- compress a folder into a single file
^pick (1)~^\- select messages by content
^prev (1)~^\- show the previous message
^prompter (1)~^\- prompting editor front end
^rcvdist (1)~^\- asynchronously redistribute new mail
^rcvpack (1)~^\- append message to file
^rcvstore (1)~^\- asynchronously incorporate new mail
^rcvtty  (1)~^\- report new mail
^refile (1)~^\- file messages in other folders
^repl (1)~^\- reply to a message
^rmf (1)~^\- remove folder
^rmm (1)~^\- remove messages
^scan (1)~^\- produce a one line per message scan listing
^send (1)~^\- send a message
^sendfiles (1)~^\- send multiple files and directories in MIME message
^show (1)~^\- show (display) messages
^slocal (1)~^\- asynchronously filter and deliver new mail
^sortm (1)~^\- sort messages
^whatnow (1)~^\- prompting front\-end for send
^whom (1)~^\- report to whom a message would go
.if '\*(ZZ'-man' \{\
.sp 1
^mh\-alias (5)~^\- alias file for nmh message system
^mh\-draft (5)~^\- draft folder facility
^mh\-format (5)~^\- format file for nmh message system
^mh\-mail (5)~^\- message format for nmh message system
^mh\-profile (5)~^\- user customization for nmh message system
^mh\-sequence (5)~^\- sequence specification for nmh message system
.sp 1
^ap (8)~^\- parse addresses 822\-style
^conflict (8)~^\- search for alias/password conflicts
^dp (8)~^\- parse dates 822\-style
^fmtdump (8)~^\- decode \fInmh\fP format files
^install\-mh (8)~^\- initialize the nmh environment
^post (8)~^\- deliver a message
.\}
.fi
.re

.if '\*(ZZ'-man' \{\
.Fi
^%bindir%~^directory containing \fInmh\fR commands
^%etcdir%~^directory containing \fInmh\fR format files
^%libdir%~^\fInmh\fR library commands
.Bu
If problems are encountered with an \fInmh\fR program, the problems should
be reported to the local maintainers of \fInmh\fR.  When doing this, the
name of the program should be reported, along with the version information
for the program.
.br
To find out what version of an \fInmh\fR program is being run, invoke
the program with the `\-version' switch.  This information includes
the version of \fInmh\fR, the host it was generated on, and the date the
program was loaded.

Send bug reports and suggestions to \fBnmh-workers@math.gatech.edu\fR.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.\" .Ps
.\" for each additional profile entry
.\" .Sa
.\" the see\-also's go here
.\" .De
.\" the first default goes here
.\" .Ds
.\" for each additional default
.\" .Co
.\" context changes go here
.\" You can also have
.\" .Hh \- the helpful hints section
.\" .Hi \- the history section
.\" .Bu \- the bugs section
.En
.\}
