/*
 * immed.c - Immediates
 *
 * Copyright (C) 1997, George Madrid
 * All rights reserved.
 */

#include <stdlib.h>

#include "config.h"
#include "nsobj.h"

/* For some reason, NewtonScript uses 3 for its true value */
#define TRUE_VALUE 3

nsObj
make_integer(int32 val)
{
     /* No bounds checking.  Just shift it up two bits */
     /* C fills in the two zero bits for me */
     return val << 2;
}

nsObj
make_boolean(int32 val)
{
     return ((val ? TRUE_VALUE : 0) << 3) | BOOLEAN_BITS;
}

nsObj
make_character(int32 val)
{
     return (val << 3) | CHARACTER_BITS;
}
