BEGIN { 
char_shift=64
## "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_";
c2n["A"]=1
c2n["B"]=2
c2n["C"]=3
c2n["D"]=4
c2n["E"]=5
c2n["F"]=6
c2n["G"]=7
c2n["H"]=8
c2n["I"]=9
c2n["J"]=10
c2n["K"]=11
c2n["L"]=12
c2n["M"]=13
c2n["N"]=14
c2n["O"]=15
c2n["P"]=16
c2n["Q"]=17
c2n["R"]=18
c2n["S"]=19
c2n["T"]=20
c2n["U"]=21
c2n["V"]=22
c2n["W"]=23
c2n["X"]=24
c2n["Y"]=25
c2n["Z"]=26
c2n["a"]=27
c2n["b"]=28
c2n["c"]=29
c2n["d"]=30
c2n["e"]=31
c2n["f"]=32
c2n["g"]=33
c2n["h"]=34
c2n["i"]=35
c2n["j"]=36
c2n["k"]=37
c2n["l"]=38
c2n["m"]=39
c2n["n"]=40
c2n["o"]=41
c2n["p"]=42
c2n["q"]=43
c2n["r"]=44
c2n["s"]=45
c2n["t"]=46
c2n["u"]=47
c2n["v"]=48
c2n["w"]=49
c2n["x"]=50
c2n["y"]=51
c2n["z"]=52
c2n["0"]=53
c2n["1"]=54
c2n["2"]=55
c2n["3"]=56
c2n["4"]=57
c2n["5"]=58
c2n["6"]=59
c2n["7"]=60
c2n["8"]=61
c2n["9"]=62
c2n["_"]=63
}
/^#/ { next }
/^[ \t]*(error_table|et)[ \t]+[a-zA-Z][a-zA-Z0-9_]+/ {
	table_number = 0
	table_name = $2
	for(i=1; i<=length(table_name); i++) {
	    table_number=(table_number*char_shift)+c2n[substr(table_name,i,1)]
	}
	table_number_base=table_number*256
	if(table_number_base > 128*256*256*256) { 
	    table_number_base -= 256*256*256*256
	}
	curr_table = table_number_base
	print "/*" > outfile
	print " * " outfile ":" > outfile
	print " * This file is automatically generated; please do not edit it." > outfile
	print " */" > outfile

	print "#ifdef __STDC__" > outfile
	print "#define NOARGS void" > outfile
	print "#else" > outfile
	print "#define NOARGS" > outfile
	print "#define const" > outfile
	print "#endif" > outfile
	print "" > outfile
	print "static const char * const text[] = {" > outfile
	table_item_count = 0
}

/^[ \t]*(error_code|ec)[ \t]+[A-Z_0-9]+,[ \t]*$/ {
	skipone=1
	next
}

/^[ \t]*(error_code|ec)[ \t]+[A-Z_0-9]+,[ \t]*".*"$/ {
	text=""
	for (i=3; i<=NF; i++) { 
	    text = text FS $i
	}
	printf "\t%s,\n", text > outfile
	curr_table++
	table_item_count++
}

{ 
	if (skipone) {
	    printf "\t%s,\n", $0 > outfile
	    curr_table++
	    table_item_count++
	}
	skipone=0
}
END {


	print "    0" > outfile
	print "};" > outfile
	print "" > outfile
	print "struct error_table {" > outfile
	print "    char const * const * msgs;" > outfile
	print "    long base;" > outfile
	print "    int n_msgs;" > outfile
	print "};" > outfile
	print "struct et_list {" > outfile
	print "    struct et_list *next;" > outfile
	print "    const struct error_table * table;" > outfile
	print "};" > outfile
	print "extern struct et_list *_et_list;" > outfile
	print "" > outfile
	print "static const struct error_table et = { text, " sprintf("%d",table_number_base) "L, " table_item_count " };" > outfile
	print "" > outfile
	print "static struct et_list link = { 0, 0 };" > outfile
	print "" > outfile
	print "void initialize_" table_name "_error_table (NOARGS) {" > outfile
	print "    if (!link.table) {" > outfile
	print "        link.next = _et_list;" > outfile
	print "        link.table = &et;" > outfile
	print "        _et_list = &link;" > outfile
	print "    }" > outfile
	print "}" > outfile
	

}
