
#ifndef _GobanP_h_INCLUDED
#define _GobanP_h_INCLUDED


#include "Goban.h"
#include <X11/Xaw/SimpleP.h>

#define MAXBOARD 19
#define MAXMOVES 500
enum { GMMove,
	   GMCapture, GMKoLeft, GMKoRight, GMKoUp, GMKoDown,
	   GMPass, GMHandicap,
	   GMRemove,
	   GMUnknown };

typedef struct {
    short type;
    short h, v;
} GMove;

typedef struct {
    short b[MAXBOARD][MAXBOARD];
    int bsize;
} GBoard;

typedef struct {
    GobanMode mode;
    Boolean removing;
    XFontStruct *font;			/* Miscellaneous configuration */
    Pixel whitePixel;
    Pixel blackPixel;
    Pixel boardPixel;
    Pixel linePixel;
    GC whiteGC;
    GC blackGC;
    GC lineGC;
    GC bgGC;
    Widget gobanMenu;
    char *title;
    char titleBuf[100];
    Widget shell;			/* my mommy */
    Widget whiteCapturesLabel, blackCapturesLabel;
    int whiteCDisplayed, blackCDisplayed;
    
    int rad;				/* Positioning and sizing info */
    int top;
    int bottom;
    int digit;
    int lineHeight;
    int *hcapH, *hcapV;			/* Arrays of 9 coordinates */

    GBoard board1, board2;		/* Game state */
    int bsize;
    GBoard *board;			/* pointer to one of the above */
    GBoard *alt;			/* pointer to the other (double-buffering action) */
    int whoseTurn;
    GMove moves[MAXMOVES];
    int numMoves;
    int curMove;
    int markH, markV;			/* -1 for no mark */
    Boolean current;			/* Are we up with the game? */

    GMove tests[MAXMOVES];		/* For trying things ahead */
    int numTests;			/* 0 if not testing now */
	
    int whiteCaptures, blackCaptures;	/* blackCaptures = #white pieces black has captured */
    GMove *lastMove;			/* Address of most recent move or NULL */

    int btnDown;			/* Is a button down? (if so, has button number) */
    int btnH, btnV;			/* If so, this is where the user is considering */
					/* (-1 -1 if not on Goban) */
    XtPointer clientData;		/* let user hook on random data */
    
} GobanPart;  

typedef struct _GobanRec {
    CorePart core;
    SimplePart simple;
    GobanPart goban;
} GobanRec;

typedef struct {
    int ignore;
} GobanClassPart;

typedef struct _ClockClassRec {
    CoreClassPart core_class;
    SimpleClassPart simple_class;
    GobanClassPart goban_class;
} GobanClassRec;

extern GobanClassRec gobanClassRec;


#endif


