

/*  Copyright (c) 1993 by Kenneth Duda <kkkken@athena.mit.edu>.  
 *  All rights reserved.
 *
 *  This program is distributed in the hope that it will be useful.
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted, so long as the following
 *  conditions are met:
 *       o credit to the author is acknowledged 
 *       o no fees or compensation are charged for use, copies, or
 *         access to this software
 *       o this copyright notice is included intact.
 *  This software is made available AS IS, and no warranty is made about 
 *  the software or its performance. 
 * 
 *  Bug descriptions, use reports, comments or suggestions are welcome.
 *  Send them to <kkkken@athena.mit.edu>.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>

#include "Goban.h"
#include "server.h"
#include "games.h"
#include "kgo.h"


usage()
{
    fprintf (stderr, "usage: kgo [ -host host ] [ -port port ] \n\
             [ -boardColor color ] [ -lineColor color ]\n\
             [ -blackColor color ] [ -whiteColor color ]\n\
             [ -boardSize nnn ]\n\
             [ toolkit-options ... ]\n");
    exit(1);
}

void ExitProgram (w, closure, call_data)
     Widget w;
     XtPointer closure;
     XtPointer call_data;
{
    exit(0);
}

void Fatal (msg)
     char *msg;
{
    Widget shell, dialog;
    
    {
	Display *dpy = XtDisplay(toplevel);
	int screen = DefaultScreen (dpy);
	static Arg args[] = { XtNx, 0, 
				  XtNy, 0,
			      };
	args[0].value = DisplayWidth(dpy, screen) / 2 - 200;
	args[1].value = DisplayHeight(dpy, screen) / 2 - 50;
	shell = XtCreatePopupShell ("fatalError", overrideShellWidgetClass, toplevel, args, XtNumber(args));
    }
    {
	static Arg args[] = { XtNlabel, 0,
			      };
	args[0].value = (XtArgVal) msg;
	dialog = XtCreateManagedWidget ("fatalDialog", dialogWidgetClass, shell, args, XtNumber(args));
    }
    XawDialogAddButton (dialog, "Exit", ExitProgram, NULL);
    XtPopup (shell, XtGrabExclusive);
    XGrabPointer (XtDisplay(shell), XtWindow(shell), TRUE, ButtonPressMask | ButtonReleaseMask, 
		  GrabModeAsync, GrabModeAsync, XtWindow(shell), None, CurrentTime);
}


static XrmOptionDescRec options[] = {
{"-lineColor",	"*goban.lineColor",		XrmoptionSepArg,	     NULL},
{"-blackColor", "*goban.blackColor",		XrmoptionSepArg,	     NULL},
{"-whiteColor", "*goban.whiteColor",		XrmoptionSepArg,	     NULL},
{"-boardColor",	"*goban.boardColor",		XrmoptionSepArg,	     NULL},
{"-host",       "*host",                        XrmoptionSepArg,	     NULL},
{"-port",       "*port",                        XrmoptionSepArg,	     NULL},
{"-userName",   "*userName",                    XrmoptionSepArg,	     NULL},
{"-user",       "*userName",                    XrmoptionSepArg,	     NULL},
{"-password",   "*password",                    XrmoptionSepArg,	     NULL},
{"-debug",      "*debug",                       XrmoptionNoArg,              "TRUE"},
};


static struct appthings {
    char *host;
    int port;
    char *userName;
    char *password;
    Boolean debug;
} appThings;

typedef struct appthings *Appthings;


static XtResource appResources[] = {
{ "host", "Host", XtRString, sizeof(String),
      XtOffset(Appthings, host), XtRString, "hellspark.wharton.upenn.edu"},
{ "port", "Port", XtRInt, sizeof(int),
      XtOffset(Appthings, port), XtRString, "6969" },
{ "userName", "UserName", XtRString, sizeof(String),
      XtOffset(Appthings, userName), XtRString, NULL },
{ "password", "Password", XtRString, sizeof(String),
      XtOffset(Appthings, password), XtRString, NULL },
{ "debug", "Debug", XtRBoolean, sizeof(Boolean),
      XtOffset(Appthings, debug), XtRBoolean, FALSE },
};

int debug;
Widget toplevel;
XtAppContext appcon;
char *userName;
char *password;

extern int server_sock;


static void handle_sock(client_data, source, id)
     XtPointer client_data;
     int *source;
     XtInputId *id;
{
    char buf[4096];
    int n;

    n = read(*source, buf, 4096);
    if (n <= 0) {
	XtRemoveInput (*id);
	Fatal("Lost connection to server");
	return;
    }
    HandleServer (buf, n);
}


    


main(argc, argv)
     int argc;
     char **argv;
{
    toplevel = XtAppInitialize (&appcon, "Kgo", options, XtNumber(options),
				(Cardinal *) &argc, argv, NULL, NULL, 0);
    if (argc != 1)
	usage();
    
    XtGetApplicationResources (toplevel, (XtPointer) &appThings,
			       appResources, XtNumber(appResources), 0, 0);
    debug = appThings.debug;
    userName = appThings.userName;
    password = appThings.password;
    QueueForServer ("toggle client 1\n");
    QueueForServer ("toggle verbose 0\n");
    ClearGames();
    ClearUsers();
    InstallTimer();
    PopupUnGame ();

    server_sock = OpenServer(appThings.host, appThings.port);
    if (server_sock >= 0)
	XtAppAddInput (appcon, server_sock, XtInputReadMask, handle_sock, appcon);
    
    XtAppMainLoop (appcon);
}    
