#ifndef __XMLTREE_H__
#define __XMLTREE_H__

/*
  This is the declaration for a simple DOM-like wrapper to the expat
  XML parser
*/

#include <vector>
#include <map>
#include <string>  

struct XMLNode
{
    ~XMLNode();
    
	std::vector<XMLNode*> Children;
	std::string Name;
	std::string Content;
	std::map<std::string,std::string> Properties;
};

class XMLTree
{
	private:
		XMLNode * Head;
	public:
		XMLTree();
		~XMLTree();

		void Parse(const char * file);
		
		XMLNode * GetHead() {return Head;}
};

#endif
