/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import org.biojava.bio.gui.sequence.LineInfo;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.Changeable;

public class SequencePanel
extends JComponent
implements SwingConstants,
SequenceRenderContext {
    private SymbolList sequence;
    private int direction = 0;
    private double scale = 12.0;
    private int lines = 1;
    private int spacer = 0;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private List views;
    private List lineInfos = new ArrayList();
    private double[] offsets;
    private double alongDim = 0.0;
    private double acrossDim = 0.0;
    private int symbolsPerLine = 0;
    private RendererMonitor theMonitor;
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent changeEvent) {
            SequencePanel.this.resizeAndValidate();
        }
    };
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent changeEvent) {
            SequencePanel.this.repaint();
        }
    };

    public SequencePanel() {
        this.views = new ArrayList();
        this.theMonitor = new RendererMonitor();
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        if (this.getFont() == null) {
            this.setFont(new Font("Times New Roman", 0, 12));
        }
        this.addPropertyChangeListener(this.theMonitor);
    }

    public void addRenderer(SequenceRenderer sequenceRenderer) {
        if (sequenceRenderer instanceof Changeable) {
            Changeable changeable = (Changeable)((Object)sequenceRenderer);
            changeable.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            changeable.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.views.add(sequenceRenderer);
        this.resizeAndValidate();
    }

    public int getDirection() {
        return this.direction;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public int getLines() {
        return this.lines;
    }

    public double getScale() {
        return this.scale;
    }

    public SymbolList getSequence() {
        return this.sequence;
    }

    public int getSpacer() {
        return this.spacer;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public int graphicsToSequence(double d) {
        return (int)(d / this.scale) + 1;
    }

    public void paintComponent(Graphics graphics) {
        double d;
        double d2;
        if (this.sequence == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D rectangle2D = graphics2D.getClip().getBounds2D();
        if (this.direction == 0) {
            d2 = rectangle2D.getMinY();
            d = rectangle2D.getMaxY();
        } else {
            d2 = rectangle2D.getMinX();
            d = rectangle2D.getMaxX();
        }
        int n = Arrays.binarySearch(this.offsets, d2);
        if (n < 0) {
            n = -n - 1;
        }
        double d3 = n == 0 ? 0.0 : this.offsets[n - 1];
        int n2 = 1 + (int)((double)n * (double)this.symbolsPerLine);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.direction == 0) {
            double_.width = this.alongDim;
            double_.height = this.acrossDim;
            graphics2D.translate(this.leadingBorder.getSize() - this.alongDim * (double)n, d3);
        } else {
            double_.width = this.acrossDim;
            double_.height = this.alongDim;
            graphics2D.translate(d3, this.leadingBorder.getSize() - this.alongDim * (double)n);
        }
        int n3 = n2;
        int n4 = n;
        while (n4 < this.lineInfos.size()) {
            int n5 = Math.min(n3 + this.symbolsPerLine - 1, this.sequence.length());
            LineInfo lineInfo = (LineInfo)this.lineInfos.get(n4);
            if (this.direction == 0) {
                double_.x = (double)n4 * this.alongDim;
                double_.y = 0.0;
            } else {
                double_.x = 0.0;
                double_.y = (double)n4 * this.alongDim;
            }
            Iterator iterator = this.views.iterator();
            while (iterator.hasNext()) {
                SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator.next();
                double d4 = lineInfo.getDepth(sequenceRenderer);
                if (this.direction == 0) {
                    double_.height = d4;
                } else {
                    double_.width = d4;
                }
                Shape shape = graphics2D.getClip();
                graphics2D.clip(double_);
                sequenceRenderer.paint(graphics2D, this, n3, n5);
                graphics2D.setClip(shape);
                if (this.direction == 0) {
                    graphics2D.translate(0.0, d4);
                    continue;
                }
                graphics2D.translate(d4, 0.0);
            }
            if (this.direction == 0) {
                graphics2D.translate(-this.alongDim, (double)this.spacer);
            } else {
                graphics2D.translate((double)this.spacer, -this.alongDim);
            }
            n3 += this.symbolsPerLine;
            if (this.offsets[n4] > d) break;
            ++n4;
        }
    }

    public void resizeAndValidate() {
        System.out.println("resizeAndValidate starting");
        Dimension dimension = null;
        if (this.sequence == null) {
            System.out.println("No sequence");
            this.alongDim = 0.0;
            double d = 0.0;
            boolean bl = false;
            this.leadingBorder.setSize(0.0);
            this.trailingBorder.setSize(0.0);
            dimension = new Dimension(0, 0);
        } else {
            Object object;
            int n;
            System.out.println("Fitting to sequence");
            Dimension dimension2 = this.getParent() != null ? this.getParent().getSize() : new Dimension(500, 400);
            int n2 = this.direction == 0 ? dimension2.width : dimension2.height;
            System.out.println("Initial width: " + n2);
            this.alongDim = this.scale * (double)this.sequence.length();
            System.out.println("alongDim (pixles needed for sequence only): " + this.alongDim);
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            Iterator iterator = this.views.iterator();
            while (iterator.hasNext()) {
                SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator.next();
                System.out.println("Renderer: " + sequenceRenderer);
                d2 = Math.max(d2, sequenceRenderer.getMinimumLeader(this));
                d3 = Math.max(d3, sequenceRenderer.getMinimumTrailer(this));
            }
            this.leadingBorder.setSize(d2);
            this.trailingBorder.setSize(d3);
            double d4 = d2 + d3;
            System.out.println("insetBefore: " + d2);
            System.out.println("insetAfter: " + d3);
            if (this.lines > 0) {
                n = this.lines;
                n2 = (int)Math.ceil(d4 + this.alongDim / (double)this.lines);
            } else {
                double d5 = n2;
                d5 -= d4;
                n = (int)Math.ceil(this.alongDim / (double)n2);
                n2 = (int)Math.ceil(d4 + this.alongDim / (double)n);
            }
            d = 0.0;
            this.symbolsPerLine = (int)Math.ceil((double)n2 / this.scale);
            if (this.symbolsPerLine < 1) {
                throw new Error("Pants");
            }
            int n3 = 1;
            this.lineInfos.clear();
            while (n3 <= this.sequence.length()) {
                LineInfo lineInfo = new LineInfo();
                int n4 = n3 + this.symbolsPerLine - 1;
                Iterator iterator2 = this.views.iterator();
                while (iterator2.hasNext()) {
                    object = (SequenceRenderer)iterator2.next();
                    lineInfo.setDepth((SequenceRenderer)object, object.getDepth(this, n3, n4));
                }
                d += lineInfo.getTotalDepth();
                this.lineInfos.add(lineInfo);
                n3 = n4 + 1;
            }
            this.offsets = new double[this.lineInfos.size()];
            int n5 = 0;
            double d6 = 0.0;
            object = this.lineInfos.iterator();
            while (object.hasNext()) {
                LineInfo lineInfo = (LineInfo)object.next();
                d6 += lineInfo.getTotalDepth();
                this.offsets[n5] = d6 += (double)this.spacer;
                ++n5;
            }
            this.alongDim = (double)this.symbolsPerLine * this.scale;
            dimension = this.direction == 0 ? new Dimension((int)Math.ceil(this.alongDim + d2 + d3), (int)d) : new Dimension((int)(d += (double)(this.spacer * (n - 1))), (int)Math.ceil(this.alongDim + d2 + d3));
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.revalidate();
        System.out.println("resizeAndValidate ending");
    }

    public double sequenceToGraphics(int n) {
        return (double)(n - 1) * this.scale;
    }

    public void setDirection(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int n2 = this.direction;
        this.direction = n;
        this.resizeAndValidate();
        this.firePropertyChange("direction", n2, this.direction);
    }

    public void setLines(int n) {
        int n2 = this.lines;
        this.lines = n;
        this.resizeAndValidate();
        this.firePropertyChange("lines", n2, n);
    }

    public void setScale(double d) {
        double d2 = this.scale;
        this.scale = d;
        this.resizeAndValidate();
        this.firePropertyChange("scale", d2, d);
    }

    public void setSequence(SymbolList symbolList) {
        SymbolList symbolList2 = this.sequence;
        if (symbolList2 != null) {
            symbolList2.removeChangeListener(this.layoutListener);
        }
        this.sequence = symbolList;
        this.sequence.addChangeListener(this.layoutListener);
        this.resizeAndValidate();
        this.firePropertyChange("sequence", symbolList2, symbolList);
    }

    public void setSpacer(int n) {
        int n2 = this.spacer;
        this.spacer = n;
        this.resizeAndValidate();
        this.firePropertyChange("spacer", n2, n);
    }

    private class RendererMonitor
    implements PropertyChangeListener {
        RendererMonitor() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SequencePanel.this.repaint();
        }
    }

    public class Border
    implements Serializable,
    SwingConstants {
        protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private double size = 0.0;
        private int alignment = 0;

        private Border() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public double getSize() {
            return this.size;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void setAlignment(int n) throws IllegalArgumentException {
            if (n != 10 && n != 11 && n != 0) {
                throw new IllegalArgumentException("Alignment must be one of the constants LEADING, TRAILING or CENTER");
            }
            int n2 = this.alignment;
            this.alignment = n;
            this.pcs.firePropertyChange("alignment", n2, n);
        }

        private void setSize(double d) {
            this.size = d;
        }
    }
}

