/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public interface FeatureHolder
extends Changeable {
    public static final ChangeType FEATURES = new ChangeType("Features have been added or removed", "org.biojava.bio.seq.FeatureHolder", "FEATURES");
    public static final FeatureHolder EMPTY_FEATURE_HOLDER = new EmptyFeatureHolder();

    public int countFeatures();

    public Feature createFeature(Feature.Template var1) throws BioException, ChangeVetoException;

    public Iterator features();

    public FeatureHolder filter(FeatureFilter var1, boolean var2);

    public void removeFeature(Feature var1) throws ChangeVetoException;

    public static final class EmptyFeatureHolder
    implements FeatureHolder {
        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public int countFeatures() {
            return 0;
        }

        public Feature createFeature(Feature.Template template) {
            throw new UnsupportedOperationException();
        }

        public Iterator features() {
            return Collections.EMPTY_SET.iterator();
        }

        public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
            return this;
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public void removeFeature(Feature feature) {
            throw new UnsupportedOperationException();
        }
    }
}

