/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractSequenceDB
implements SequenceDB {
    protected transient ChangeSupport changeSupport = null;

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        this.changeSupport.addChangeListener(changeListener, changeType);
    }

    public void addSequence(Sequence sequence) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSequenceDB is immutable");
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public abstract String getName();

    public abstract Sequence getSequence(String var1) throws IllegalIDException, BioException;

    public abstract Set ids();

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.changeSupport.removeChangeListener(changeListener, changeType);
    }

    public void removeSequence(String string) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSequenceDB is immutable");
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator pID;
            {
                this.pID = AbstractSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.pID.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return AbstractSequenceDB.this.getSequence((String)this.pID.next());
            }
        };
    }
}

