/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;

public class SimpleFeature
extends AbstractChangeable
implements Feature,
RealizingFeatureHolder,
Serializable {
    private SimpleFeatureHolder featureHolder;
    private Location loc;
    private String type;
    private String source;
    private FeatureHolder parent;
    private Annotation annotation;

    public SimpleFeature(Sequence sequence, FeatureHolder featureHolder, Feature.Template template) throws IllegalArgumentException {
        if (template.location == null) {
            throw new IllegalArgumentException("Location can not be null. Did you mean Location.EMPTY_LOCATION?");
        }
        this.parent = featureHolder;
        this.loc = template.location;
        this.type = template.type;
        this.source = template.source;
        this.annotation = new SimpleAnnotation(template.annotation);
    }

    public int countFeatures() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().countFeatures();
        }
        return 0;
    }

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        Feature feature = this.realizeFeature(this, template);
        this.getFeatureHolder().addFeature(feature);
        return feature;
    }

    protected boolean featureHolderAllocated() {
        return this.featureHolder != null;
    }

    public Iterator features() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().features();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected void fillTemplate(Feature.Template template) {
        template.location = this.getLocation();
        template.type = this.getType();
        template.source = this.getSource();
        template.annotation = this.getAnnotation();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().filter(featureFilter, bl);
        }
        return new SimpleFeatureHolder();
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    protected SimpleFeatureHolder getFeatureHolder() {
        if (this.featureHolder == null) {
            this.featureHolder = new SimpleFeatureHolder();
        }
        return this.featureHolder;
    }

    public Location getLocation() {
        return this.loc;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    public Sequence getSequence() {
        FeatureHolder featureHolder = this;
        while (featureHolder instanceof Feature) {
            featureHolder = ((Feature)featureHolder).getParent();
        }
        try {
            return (Sequence)featureHolder;
        }
        catch (ClassCastException classCastException) {
            throw new BioError("Feature doesn't seem to have a Sequence ancestor.");
        }
    }

    public String getSource() {
        return this.source;
    }

    public SymbolList getSymbols() {
        return this.getLocation().symbols(this.getSequence());
    }

    public String getType() {
        return this.type;
    }

    public Feature.Template makeTemplate() {
        Feature.Template template = new Feature.Template();
        this.fillTemplate(template);
        return template;
    }

    public Feature realizeFeature(FeatureHolder featureHolder, Feature.Template template) throws BioException {
        try {
            RealizingFeatureHolder realizingFeatureHolder = (RealizingFeatureHolder)this.getParent();
            return realizingFeatureHolder.realizeFeature(featureHolder, template);
        }
        catch (ClassCastException classCastException) {
            throw new BioException("Couldn't propagate feature creation request.");
        }
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        this.getFeatureHolder().removeFeature(feature);
    }

    public String toString() {
        return "Feature " + this.getType() + " " + this.getSource() + " " + this.getLocation();
    }
}

