/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.FeatureTableParser;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

class SwissprotFeatureTableParser
extends FeatureTableParser {
    SwissprotFeatureTableParser(SeqIOListener seqIOListener, String string) {
        super(seqIOListener, string);
    }

    protected Feature.Template buildFeatureTemplate(String string, Location location, StrandedFeature.Strand strand, String string2, Map map) {
        Feature.Template template = new Feature.Template();
        template.annotation = new SimpleAnnotation();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                template.annotation.setProperty(entry.getKey(), entry.getValue());
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Assertion Failure: Couldn't set up the annotation");
            }
        }
        template.location = location;
        template.type = string;
        template.source = string2;
        return template;
    }

    public void endFeature() throws BioException {
        this.featureAttributes.put(this.featureBuf.toString(), "");
        super.endFeature();
    }

    public void featureData(String string) throws BioException {
        boolean bl = false;
        if (string.charAt(5) != ' ') {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.featureLocation = this.getLocation(stringTokenizer);
            string = string.length() >= 20 ? string.substring(20) : "";
            bl = true;
        }
        if (bl) {
            this.featureBuf.setLength(0);
        }
        this.featureBuf.append(" " + string.trim());
        bl = false;
    }

    private Index getIndex(StringTokenizer stringTokenizer) throws BioException {
        Index index;
        String string = stringTokenizer.nextToken();
        boolean bl = false;
        if (string.indexOf(60) != -1 && string.indexOf(62) != -1) {
            string = string.substring(1);
            bl = true;
        }
        try {
            index = new Index(new Integer(string), bl);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BioException("bad locator: " + string);
        }
        return index;
    }

    private Location getLocation(StringTokenizer stringTokenizer) throws BioException {
        Index index = this.getIndex(stringTokenizer);
        Index index2 = this.getIndex(stringTokenizer);
        Integer n = index.point;
        Integer n2 = index2.point;
        boolean bl = index.isFuzzy;
        boolean bl2 = index2.isFuzzy;
        Location location = n2.equals(n) ? new PointLocation(n) : new RangeLocation(n, n2);
        if (bl || bl2) {
            location = new FuzzyLocation(location, bl, bl2);
        }
        return location;
    }

    public boolean inFeature() {
        return super.inFeature();
    }

    public void startFeature(String string) throws BioException {
        super.startFeature(string);
    }

    private class Index {
        public boolean isFuzzy;
        public Integer point;

        public Index(Integer n, boolean bl) {
            this.point = n;
            this.isFuzzy = bl;
        }
    }
}

