/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.HashedAlphabetIndex;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.InfiniteCrossProductAlphabet;
import org.biojava.bio.symbol.LinearAlphabetIndex;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleAtomicSymbol;
import org.biojava.bio.symbol.SimpleBasisSymbol;
import org.biojava.bio.symbol.SimpleCrossProductAlphabet;
import org.biojava.bio.symbol.SimpleSymbol;
import org.biojava.bio.symbol.SparseCrossProductAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class AlphabetManager {
    private static AlphabetManager am;
    private static Map nameToAlphabet;
    private static Map nameToSymbol;
    private static Map crossProductAlphabets;
    private static Map ambiguitySymbols;
    private static GapSymbol gapSymbol;
    private static Map alphabetToIndex;
    static /* synthetic */ Class class$org$biojava$bio$symbol$AlphabetManager;

    static {
        alphabetToIndex = new HashMap();
        nameToAlphabet = new HashMap();
        nameToSymbol = new HashMap();
        ambiguitySymbols = new HashMap();
        gapSymbol = new GapSymbol();
        ambiguitySymbols.put(new HashSet(), gapSymbol);
        try {
            InputStream inputStream = (class$org$biojava$bio$symbol$AlphabetManager != null ? class$org$biojava$bio$symbol$AlphabetManager : (class$org$biojava$bio$symbol$AlphabetManager = AlphabetManager.class$("org.biojava.bio.symbol.AlphabetManager"))).getClassLoader().getResourceAsStream("org/biojava/bio/symbol/AlphabetManager.xml");
            if (inputStream == null) {
                throw new BioError("Couldn't locate AlphabetManager.xml.  Badly built biojava archive?");
            }
            InputSource inputSource = new InputSource(inputStream);
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            Document document = dOMParser.getDocument();
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    String string = element.getNodeName();
                    if (string.equals("symbol")) {
                        nameToSymbol.put(element.getAttribute("name"), AlphabetManager.symbolFromXML(element, null));
                    } else if (string.equals("alphabet")) {
                        String string2 = element.getAttribute("name");
                        String string3 = element.getAttribute("parent");
                        try {
                            SimpleAlphabet simpleAlphabet = AlphabetManager.alphabetFromXML(element, nameToSymbol);
                            if (string3 != null && string3.length() != 0) {
                                string2 = String.valueOf(string3) + "-" + string2;
                                FiniteAlphabet finiteAlphabet = (FiniteAlphabet)AlphabetManager.alphabetForName(string3);
                                Iterator iterator = finiteAlphabet.iterator();
                                while (iterator.hasNext()) {
                                    simpleAlphabet.addSymbol((Symbol)iterator.next());
                                }
                            }
                            simpleAlphabet.setName(string2);
                            AlphabetManager.registerAlphabet(string2, simpleAlphabet);
                        }
                        catch (Exception exception) {
                            throw new BioError(exception, "Couldn't construct alphabet " + string2);
                        }
                    }
                }
                ++n;
            }
        }
        catch (SAXParseException sAXParseException) {
            throw new BioError(sAXParseException, String.valueOf(((SAXException)sAXParseException).toString()) + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber());
        }
        catch (Exception exception) {
            throw new BioError(exception, "Unable to initialize AlphabetManager");
        }
    }

    public static Alphabet alphabetForName(String string) throws NoSuchElementException {
        Alphabet alphabet = (Alphabet)nameToAlphabet.get(string);
        if (alphabet == null) {
            if (string.startsWith("(") && string.endsWith(")")) {
                alphabet = AlphabetManager.generateCrossProductAlphaFromName(string);
            } else {
                throw new NoSuchElementException("No alphabet for name " + string + " could be found");
            }
        }
        return alphabet;
    }

    private static SimpleAlphabet alphabetFromXML(Element element, Map hashMap) throws BioException {
        hashMap = new HashMap<String, AtomicSymbol>(hashMap);
        WellKnownAlphabet wellKnownAlphabet = new WellKnownAlphabet();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                try {
                    String string = element2.getNodeName();
                    if (string.equals("description")) {
                        wellKnownAlphabet.getAnnotation().setProperty("description", element2.getFirstChild().getNodeValue());
                    } else if (string.equals("symbol")) {
                        AtomicSymbol atomicSymbol = AlphabetManager.symbolFromXML(element2, wellKnownAlphabet);
                        String string2 = element2.getAttribute("name");
                        if (string2 != null) {
                            hashMap.put(string2, atomicSymbol);
                        }
                        wellKnownAlphabet.addSymbol(atomicSymbol);
                    } else if (string.equals("symbolref")) {
                        wellKnownAlphabet.addSymbol((Symbol)hashMap.get(element2.getAttribute("name")));
                    } else if (string.equals("ambiguity")) {
                        wellKnownAlphabet.addAmbiguity(AlphabetManager.ambiguityFromXML(wellKnownAlphabet, element2, hashMap));
                    }
                }
                catch (Exception exception) {
                    throw new BioException(exception, "Couldn't parse element " + element2);
                }
            }
            ++n;
        }
        return wellKnownAlphabet;
    }

    public static Iterator alphabets() {
        return nameToAlphabet.values().iterator();
    }

    private static Symbol ambiguityFromXML(Alphabet alphabet, Element element, Map map) throws IllegalSymbolException {
        Object object;
        char c = '\u0000';
        String string = null;
        String string2 = null;
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element) {
                Object object2;
                Element element2 = (Element)object;
                String string3 = element2.getNodeName();
                if (string3.equals("symbol")) {
                    object2 = element2.getChildNodes();
                    int n2 = 0;
                    while (n2 < object2.getLength()) {
                        Node node = object2.item(n2);
                        if (node instanceof Element) {
                            Element element3 = (Element)node;
                            String string4 = element3.getNodeName();
                            String string5 = element3.getFirstChild().getNodeValue();
                            if (string4.equals("short")) {
                                c = string5.charAt(0);
                            } else if (string4.equals("long")) {
                                string = string5;
                            } else if (string4.equals("description")) {
                                string2 = string5;
                            }
                        }
                        ++n2;
                    }
                } else if (string3.equals("symbolref")) {
                    object2 = element2.getAttribute("name");
                    Symbol symbol = (Symbol)map.get(object2);
                    if (symbol == null) {
                        throw new IllegalSymbolException("Got symbol ref to " + (String)object2 + " but it doesn't match anything");
                    }
                    hashSet.add(symbol);
                }
            }
            ++n;
        }
        object = AlphabetManager.createSymbol(c, Annotation.EMPTY_ANNOTATION, hashSet, alphabet);
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static AtomicSymbol createSymbol(char c, String string, Annotation annotation) {
        FundamentalAtomicSymbol fundamentalAtomicSymbol = new FundamentalAtomicSymbol(string, c, annotation);
        return fundamentalAtomicSymbol;
    }

    public static Symbol createSymbol(char c, Annotation annotation, List list, Alphabet alphabet) throws IllegalSymbolException {
        Iterator iterator = list.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (!(symbol instanceof BasisSymbol)) continue;
            ++n;
            if (!(symbol instanceof AtomicSymbol)) continue;
            ++n2;
        }
        if (n2 == list.size()) {
            return new SimpleAtomicSymbol(c, annotation, list);
        }
        if (n == list.size()) {
            return new SimpleBasisSymbol(c, annotation, list, new SimpleAlphabet(AlphabetManager.expandMatches(alphabet, list, new ArrayList())));
        }
        return new SimpleSymbol(c, annotation, new SimpleAlphabet(AlphabetManager.expandBasis(alphabet, list, new ArrayList())));
    }

    public static Symbol createSymbol(char c, Annotation annotation, Set set, Alphabet alphabet) throws IllegalSymbolException {
        Object object;
        if (set.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = -1;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object = (Symbol)iterator.next();
            if (object instanceof AtomicSymbol) {
                object2 = (AtomicSymbol)object;
                int n2 = object2.getSymbols().size();
                if (n == -1) {
                    n = n2;
                } else if (n != n2) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                hashSet.add(object2);
                continue;
            }
            object2 = ((FiniteAlphabet)object.getMatches()).iterator();
            while (object2.hasNext()) {
                AtomicSymbol atomicSymbol = (AtomicSymbol)object2.next();
                int n3 = atomicSymbol.getSymbols().size();
                if (n == -1) {
                    n = n3;
                } else if (n != n3) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                hashSet.add(atomicSymbol);
            }
        }
        if (hashSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        if (hashSet.size() == 1) {
            return (Symbol)hashSet.iterator().next();
        }
        if (n == 1) {
            return new SimpleBasisSymbol(c, annotation, new SimpleAlphabet(hashSet));
        }
        object = AlphabetManager.factorize(alphabet, hashSet);
        if (object == null) {
            return new SimpleSymbol(c, annotation, new SimpleAlphabet(hashSet));
        }
        return new SimpleBasisSymbol(c, annotation, (List)object, new SimpleAlphabet(AlphabetManager.expandBasis(alphabet, (List)object, new ArrayList())));
    }

    private static Set expandBasis(Alphabet alphabet, List list, List list2) {
        int n = list2.size();
        if (n < list.size()) {
            Symbol symbol = (Symbol)list.get(n);
            if (symbol instanceof AtomicSymbol) {
                list2.add(symbol);
                return AlphabetManager.expandBasis(alphabet, list, list2);
            }
            HashSet hashSet = new HashSet();
            Iterator iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
            while (iterator.hasNext()) {
                AtomicSymbol atomicSymbol = (AtomicSymbol)iterator.next();
                ArrayList<AtomicSymbol> arrayList = new ArrayList<AtomicSymbol>(list2);
                arrayList.add(atomicSymbol);
                hashSet.addAll(AlphabetManager.expandBasis(alphabet, list, arrayList));
            }
            return hashSet;
        }
        try {
            return Collections.singleton(alphabet.getSymbol(list2));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Assertion Failure: Should just have legal AtomicSymbol instances.");
        }
    }

    private static Set expandMatches(Alphabet alphabet, List list, List list2) {
        int n = list2.size();
        if (n < list.size()) {
            BasisSymbol basisSymbol = (BasisSymbol)list.get(n);
            if (basisSymbol instanceof AtomicSymbol) {
                list2.add(basisSymbol);
                return AlphabetManager.expandMatches(alphabet, list, list2);
            }
            HashSet hashSet = new HashSet();
            Iterator iterator = ((FiniteAlphabet)basisSymbol.getMatches()).iterator();
            while (iterator.hasNext()) {
                ArrayList<AtomicSymbol> arrayList = new ArrayList<AtomicSymbol>(list2);
                arrayList.add((AtomicSymbol)iterator.next());
                hashSet.addAll(AlphabetManager.expandMatches(alphabet, list, arrayList));
            }
            return hashSet;
        }
        try {
            Symbol symbol = alphabet.getSymbol(list2);
            if (symbol instanceof AtomicSymbol) {
                return Collections.singleton((AtomicSymbol)symbol);
            }
            HashSet<AtomicSymbol> hashSet = new HashSet<AtomicSymbol>();
            Iterator iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
            while (iterator.hasNext()) {
                hashSet.add((AtomicSymbol)iterator.next());
            }
            return hashSet;
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Assertion Failure: Couldn't create symbol.");
        }
    }

    public static List factorize(Alphabet alphabet, Set set) throws IllegalSymbolException {
        List list = alphabet.getAlphabets();
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        int n = set.size();
        HashSet<AtomicSymbol> hashSet = new HashSet<AtomicSymbol>();
        int n2 = 0;
        while (n2 < list.size()) {
            Alphabet alphabet2 = (Alphabet)list.get(n2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add((AtomicSymbol)((AtomicSymbol)iterator.next()).getSymbols().get(n2));
            }
            int n3 = hashSet.size();
            if (n % n3 != 0) {
                return null;
            }
            n /= n3;
            arrayList.add(alphabet2.getAmbiguity(hashSet));
            hashSet.clear();
            ++n2;
        }
        if (n != 1) {
            return null;
        }
        return arrayList;
    }

    public static Alphabet generateCrossProductAlphaFromName(String string) {
        if (!string.startsWith("(") || !string.endsWith(")")) {
            throw new BioError("Can't parse " + string + " into a cross-product alphabet as it is not bracketed");
        }
        string = string.substring(1, string.length() - 1).trim();
        ArrayList<Alphabet> arrayList = new ArrayList<Alphabet>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            Object var3_3 = null;
            if (string.charAt(n) == '(') {
                n2 = 1;
                int n3 = n + 1;
                while (n3 < string.length() && n2 > 0) {
                    char c = string.charAt(n3);
                    if (c == '(') {
                        ++n2;
                    } else if (c == ')') {
                        --n2;
                    }
                    ++n3;
                }
                if (n2 == 0) {
                    arrayList.add(AlphabetManager.alphabetForName(string.substring(n, n3)));
                    n = n3;
                    continue;
                }
                throw new BioError("Error parsing alphabet name: could not find matching bracket\n" + string.substring(n));
            }
            n2 = string.indexOf(" x ", n);
            if (n2 < 0) {
                arrayList.add(AlphabetManager.alphabetForName(string.substring(n).trim()));
                n = string.length();
                continue;
            }
            arrayList.add(AlphabetManager.alphabetForName(string.substring(n, n2).trim()));
            n = n2 + " x ".length();
        }
        return AlphabetManager.getCrossProductAlphabet(arrayList);
    }

    public static AlphabetIndex getAlphabetIndex(FiniteAlphabet finiteAlphabet) {
        int n = 160;
        AlphabetIndex alphabetIndex = (AlphabetIndex)alphabetToIndex.get(finiteAlphabet);
        if (alphabetIndex == null) {
            int n2 = finiteAlphabet.size();
            alphabetIndex = n2 <= 160 ? new LinearAlphabetIndex(finiteAlphabet) : new HashedAlphabetIndex(finiteAlphabet);
            alphabetToIndex.put(finiteAlphabet, alphabetIndex);
        }
        return alphabetIndex;
    }

    public static AlphabetIndex getAlphabetIndex(Symbol[] symbolArray) throws IllegalSymbolException, BioException {
        return new LinearAlphabetIndex(symbolArray);
    }

    public static Alphabet getCrossProductAlphabet(List list) {
        return AlphabetManager.getCrossProductAlphabet(list, null);
    }

    public static Alphabet getCrossProductAlphabet(List list, Alphabet alphabet) {
        if (list.size() == 1) {
            return (Alphabet)list.get(0);
        }
        if (crossProductAlphabets == null) {
            crossProductAlphabets = new HashMap();
        }
        ListWrapper listWrapper = new ListWrapper(list);
        Alphabet alphabet2 = (Alphabet)crossProductAlphabets.get(listWrapper);
        int n = 1;
        if (alphabet2 == null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Alphabet alphabet3 = (Alphabet)iterator.next();
                if (!(alphabet3 instanceof FiniteAlphabet)) {
                    alphabet2 = new InfiniteCrossProductAlphabet(list);
                    break;
                }
                n *= ((FiniteAlphabet)alphabet3).size();
            }
            if (alphabet2 == null) {
                try {
                    alphabet2 = n >= 0 && n < 1000 ? new SimpleCrossProductAlphabet(list, alphabet) : new SparseCrossProductAlphabet(list);
                }
                catch (IllegalAlphabetException illegalAlphabetException) {
                    throw new BioError("Could not create SimpleCrossProductAlphabet for " + list + " even though we should be able to. No idea what is wrong.");
                }
            }
            crossProductAlphabets.put(listWrapper, alphabet2);
            AlphabetManager.registerAlphabet(alphabet2.getName(), alphabet2);
        }
        return alphabet2;
    }

    public static Symbol getGapSymbol() {
        return gapSymbol;
    }

    public static AlphabetManager instance() {
        if (am == null) {
            am = new AlphabetManager();
        }
        return am;
    }

    public static void registerAlphabet(String string, Alphabet alphabet) {
        nameToAlphabet.put(string, alphabet);
    }

    public static Symbol symbolForName(String string) throws NoSuchElementException {
        Symbol symbol = (Symbol)nameToSymbol.get(string);
        if (symbol == null) {
            throw new NoSuchElementException("Could not find symbol under the name " + string);
        }
        return symbol;
    }

    private static AtomicSymbol symbolFromXML(Element element, WellKnownAlphabet wellKnownAlphabet) {
        Object object;
        char c = '\u0000';
        String string = null;
        String string2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element) {
                Element element2 = (Element)object;
                String string3 = element2.getNodeName();
                String string4 = element2.getFirstChild().getNodeValue();
                if (string3.equals("short")) {
                    c = string4.charAt(0);
                } else if (string3.equals("long")) {
                    string = string4;
                } else if (string3.equals("description")) {
                    string2 = string4;
                }
            }
            ++n;
        }
        object = new WellKnownSymbol(wellKnownAlphabet, c, string, new SimpleAnnotation());
        try {
            object.getAnnotation().setProperty("description", string2);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "Assertion voilated: there should be nothing to veto this property");
        }
        return object;
    }

    private static class WellKnownAlphabet
    extends SimpleAlphabet
    implements Serializable {
        WellKnownAlphabet() {
        }

        private Object writeReplace() {
            return new OPH(this.getName());
        }

        private static class OPH
        implements Serializable {
            private String name;

            public OPH() {
            }

            public OPH(String string) {
                this.name = string;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    Alphabet alphabet = AlphabetManager.alphabetForName(this.name);
                    return alphabet;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new InvalidObjectException("Couldn't resolve alphabet " + this.name);
                }
            }
        }
    }

    private static class WellKnownSymbol
    extends FundamentalAtomicSymbol
    implements Serializable {
        WellKnownAlphabet alpha;

        public WellKnownSymbol(WellKnownAlphabet wellKnownAlphabet, char c, String string, Annotation annotation) {
            super(string, c, annotation);
            this.alpha = wellKnownAlphabet;
        }

        private Object writeReplace() {
            return new OPH(this.alpha, this.getName());
        }

        private static class OPH
        implements Serializable {
            private WellKnownAlphabet alpha;
            private String name;

            public OPH(WellKnownAlphabet wellKnownAlphabet, String string) {
                this.alpha = wellKnownAlphabet;
                this.name = string;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    if (this.alpha != null) {
                        return this.alpha.getParser("name").parseToken(this.name);
                    }
                    return AlphabetManager.symbolForName(this.name);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new InvalidObjectException("Couldn't resolve symbol " + this.name + " as there was no parser");
                }
                catch (IllegalSymbolException illegalSymbolException) {
                    throw new InvalidObjectException("Couldn't resolve symbol " + this.name + ": " + illegalSymbolException.getMessage());
                }
            }
        }
    }

    private static class GapSymbol
    implements Symbol,
    Serializable {
        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public Alphabet getMatches() {
            return Alphabet.EMPTY_ALPHABET;
        }

        public String getName() {
            return "gap";
        }

        public char getToken() {
            return '-';
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }
    }
}

