/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

public class SimpleEmissionState
implements EmissionState,
Serializable {
    private Distribution dis;
    private String name;
    private Annotation ann;
    private int[] advance;
    private Alphabet matches;
    private transient ChangeSupport changeSupport = null;

    public final Annotation getAnnotation() {
        return this.ann;
    }

    public final void setAnnotation(Annotation ann) {
        this.ann = ann;
    }

    public final Distribution getDistribution() {
        return this.dis;
    }

    public final void setDistribution(Distribution dis) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.dis = dis;
        } else {
            ChangeEvent ce = new ChangeEvent(this, EmissionState.DISTRIBUTION, this.dis, dis);
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(ce);
                this.dis = dis;
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public int[] getAdvance() {
        return this.advance;
    }

    public void setAdvance(int[] advance) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.advance = advance;
        } else {
            ChangeEvent ce = new ChangeEvent(this, EmissionState.ADVANCE, this.advance, advance);
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(ce);
                this.advance = advance;
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public char getToken() {
        return this.name.charAt(0);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public Alphabet getMatches() {
        return this.matches;
    }

    public Set getBases() {
        return Collections.singleton(this);
    }

    public List getSymbols() {
        return new SingletonList(this);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }

    public SimpleEmissionState(String name, Annotation ann, int[] advance, Distribution dis) {
        this.name = name;
        this.ann = ann;
        this.advance = advance;
        this.dis = dis;
        this.matches = new SingletonAlphabet(this);
    }

    public void registerWithTrainer(ModelTrainer trainer) {
        trainer.registerDistribution(this.getDistribution());
    }
}

