/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.PlainStyle;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.gui.TextLogoPainter;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class DistributionLogo
extends JComponent {
    private static final LogoPainter DEFAULT_LOGO_PAINTER = new TextLogoPainter();
    private static double bits = Math.log(2.0);
    private Distribution dist;
    private LogoPainter logoPainter = DEFAULT_LOGO_PAINTER;
    private SymbolStyle style = new PlainStyle(Color.black, Color.gray);

    public Distribution getDistribution() {
        return this.dist;
    }

    public void setDistribution(Distribution dist) throws IllegalAlphabetException {
        this.firePropertyChange("dist", this.dist, dist);
        this.dist = dist;
    }

    public LogoPainter getLogoPainter() {
        return this.logoPainter;
    }

    public void setLogoPainter(LogoPainter logoPainter) {
        this.firePropertyChange("logoPainter", this.logoPainter, logoPainter);
        this.logoPainter = logoPainter;
    }

    public SymbolStyle getStyle() {
        return this.style;
    }

    public void setStyle(SymbolStyle style) {
        this.firePropertyChange("style", this.style, style);
        this.style = style;
    }

    public DistributionLogo() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                String name = pce.getPropertyName();
                if (name.equals("dist") || name.equals("logoPainter") || name.equals("style")) {
                    DistributionLogo.this.repaint();
                }
            }
        });
        Dimension d = new Dimension(20, 20);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
    }

    public double entropy(Symbol s) throws IllegalSymbolException {
        Distribution dist = this.getDistribution();
        double p = dist.getWeight(s);
        double lp = Math.log(p);
        return -p * lp / bits;
    }

    public double totalBits() {
        return Math.log(((FiniteAlphabet)this.getDistribution().getAlphabet()).size()) / bits;
    }

    public double totalInformation() {
        double inf = this.totalBits();
        Distribution eDistribution = this.getDistribution();
        Iterator i = ((FiniteAlphabet)eDistribution.getAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            try {
                inf -= this.entropy(s);
            }
            catch (IllegalSymbolException ire) {
                throw new BioError(ire, "Symbol evaporated while calculating information");
            }
        }
        return inf;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g2.getClipBounds();
        if (this.isOpaque()) {
            g2.clearRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.getDistribution() == null) {
            return;
        }
        this.getLogoPainter().paintLogo(g, this);
    }
}

