/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class BasicFeatureRenderer
extends AbstractChangeable
implements FeatureRenderer {
    public static final ChangeType FILL = new ChangeType("The fill paint has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "FILL", SequenceRenderContext.REPAINT);
    public static final ChangeType OUTLINE = new ChangeType("The outline paint has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "OUTLINE", SequenceRenderContext.REPAINT);
    public static final ChangeType SIZE = new ChangeType("The size of the arrow has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "SIZE", SequenceRenderContext.LAYOUT);
    public static final ChangeType SCOOP = new ChangeType("The scoop of the arrow has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "SCOOP", SequenceRenderContext.REPAINT);
    private Paint fill = Color.red;
    private Paint outline = Color.black;
    private double arrowSize = 15.0;
    private double arrowScoop = 4.0;

    public void setFill(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, FILL, p, this.fill));
                cs.firePreChangeEvent(ce);
                this.fill = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.fill = p;
        }
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setOutline(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, OUTLINE, p, this.outline));
                cs.firePreChangeEvent(ce);
                this.outline = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.outline = p;
        }
    }

    public Paint getOutline() {
        return this.outline;
    }

    public void setArrowSize(double arrowSize) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, SIZE, new Double(this.arrowSize), new Double(arrowSize)));
                cs.firePreChangeEvent(ce);
                this.arrowSize = arrowSize;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.arrowSize = arrowSize;
        }
    }

    public double getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowScoop(double arrowScoop) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, SIZE, new Double(this.arrowSize), new Double(this.arrowSize)));
                cs.firePreChangeEvent(ce);
                this.arrowScoop = arrowScoop;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.arrowScoop = arrowScoop;
        }
    }

    public double getArrowScoop() {
        return this.arrowScoop;
    }

    public void renderFeature(Graphics2D g, Feature f, SequenceRenderContext src) {
        Shape s = null;
        Location loc = f.getLocation();
        float min = (float)src.sequenceToGraphics(loc.getMin());
        float max = (float)src.sequenceToGraphics(loc.getMax());
        float depth = (float)(this.arrowSize + 2.0 * this.arrowScoop);
        if ((double)(max - min) >= this.arrowSize && f instanceof StrandedFeature) {
            StrandedFeature.Strand strand = ((StrandedFeature)f).getStrand();
            if (src.getDirection() == 0) {
                float minY = 0.0f;
                float maxY = depth;
                float minYS = minY + (float)this.arrowScoop;
                float maxYS = maxY - (float)this.arrowScoop;
                float midY = (minY + maxY) * 0.5f;
                float minX = min;
                float maxX = max;
                if (strand == StrandedFeature.POSITIVE) {
                    float midX = maxX - (float)this.arrowSize;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(minX, minYS);
                    path.lineTo(midX, minYS);
                    path.lineTo(midX, minY);
                    path.lineTo(maxX, midY);
                    path.lineTo(midX, maxY);
                    path.lineTo(midX, maxYS);
                    path.lineTo(minX, maxYS);
                    path.closePath();
                    s = path;
                } else if (strand == StrandedFeature.NEGATIVE) {
                    float midX = minX + (float)this.arrowSize;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(maxX, minYS);
                    path.lineTo(midX, minYS);
                    path.lineTo(midX, minY);
                    path.lineTo(minX, midY);
                    path.lineTo(midX, maxY);
                    path.lineTo(midX, maxYS);
                    path.lineTo(maxX, maxYS);
                    path.closePath();
                    s = path;
                }
            } else {
                float minX = 0.0f;
                float maxX = depth;
                float minXS = minX + (float)this.arrowScoop;
                float maxXS = maxX - (float)this.arrowScoop;
                float midX = (minX + maxX) * 0.5f;
                float minY = min;
                float maxY = max;
                if (strand == StrandedFeature.POSITIVE) {
                    float midY = maxY - (float)this.arrowSize;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(minXS, minY);
                    path.lineTo(minXS, midY);
                    path.lineTo(minX, midY);
                    path.lineTo(midX, maxY);
                    path.lineTo(maxX, midY);
                    path.lineTo(maxXS, midY);
                    path.lineTo(maxXS, minY);
                    path.closePath();
                    s = path;
                } else if (strand == StrandedFeature.NEGATIVE) {
                    float midY = minY + (float)this.arrowSize;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(minXS, maxY);
                    path.lineTo(minXS, midY);
                    path.lineTo(minX, midY);
                    path.lineTo(midX, minY);
                    path.lineTo(maxX, midY);
                    path.lineTo(maxXS, midY);
                    path.lineTo(maxXS, maxY);
                    path.closePath();
                    s = path;
                }
            }
        }
        if (s == null) {
            s = src.getDirection() == 0 ? new Rectangle2D.Double(min, 0.0, Math.max(1.0, (double)(max - min)), 2.0 * this.arrowScoop + this.arrowSize) : new Rectangle2D.Double(0.0, min, 2.0 * this.arrowScoop + this.arrowSize, Math.max(1.0, (double)(max - min)));
        }
        if (this.fill != null) {
            g.setPaint(this.fill);
            g.fill(s);
        }
        if (this.outline != null && (double)(max - min) > 4.0) {
            g.setPaint(this.outline);
            g.draw(s);
        }
    }

    public double getDepth(SequenceRenderContext src) {
        return this.arrowSize + 2.0 * this.arrowScoop + 1.0;
    }

    public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
        return hits;
    }
}

