/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JComponent;
import org.biojava.bio.gui.sequence.AbstractBeadRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class EllipticalBeadRenderer
extends AbstractBeadRenderer
implements FeatureRenderer {
    public static final ChangeType RATIO = new ChangeType("The shape of the features has changed", "org.biojava.bio.gui.sequence.EllipticalBeadRenderer", "RATIO", SequenceRenderContext.LAYOUT);
    protected double dimensionRatio;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public EllipticalBeadRenderer() {
        this.dimensionRatio = 2.0;
    }

    public EllipticalBeadRenderer(double beadDepth, double beadDisplacement, Paint beadOutline, Paint beadFill, Stroke beadStroke, double dimensionRatio) {
        super(beadDepth, beadDisplacement, beadOutline, beadFill, beadStroke);
        dimensionRatio = 2.0;
    }

    protected void renderBead(Graphics2D g, Feature f, SequenceRenderContext context) {
        Ellipse2D.Double shape;
        Location loc = f.getLocation();
        int min = loc.getMin();
        int max = loc.getMax();
        int dif = max - min;
        if (context.getDirection() == 0) {
            double posXW = context.sequenceToGraphics(min);
            double posYN = this.beadDisplacement;
            double width = Math.max((double)(dif + 1) * context.getScale(), 1.0);
            double height = Math.min(this.beadDepth, width / this.dimensionRatio);
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = EllipticalBeadRenderer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(context)) {
                Rectangle visible = ((JComponent)((Object)context)).getVisibleRect();
                AffineTransform t = g.getTransform();
                t.translate(visible.getX(), visible.getY());
                try {
                    if (!t.createInverse().createTransformedShape(visible).intersects(posXW, posYN, width, height)) {
                        return;
                    }
                }
                catch (NoninvertibleTransformException ni) {
                    ni.printStackTrace();
                }
            }
            if (height < this.beadDepth) {
                posYN += (this.beadDepth - height) / this.dimensionRatio;
            }
            shape = new Ellipse2D.Double(posXW, posYN, width, height);
        } else {
            double posXW = this.beadDisplacement;
            double posYN = context.sequenceToGraphics(min);
            double height = Math.max(((double)dif + 1.0) * context.getScale(), 1.0);
            double width = Math.min(this.beadDepth, height / this.dimensionRatio);
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = EllipticalBeadRenderer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(context)) {
                Rectangle visible = ((JComponent)((Object)context)).getVisibleRect();
                AffineTransform t = g.getTransform();
                t.translate(visible.getX(), visible.getY());
                try {
                    if (!t.createInverse().createTransformedShape(visible).intersects(posXW, posYN, width, height)) {
                        return;
                    }
                }
                catch (NoninvertibleTransformException ni) {
                    ni.printStackTrace();
                }
            }
            if (width < this.beadDepth) {
                posXW += (this.beadDepth - width) / this.dimensionRatio;
            }
            shape = new Ellipse2D.Double(posXW, posYN, width, height);
        }
        g.setPaint(this.beadFill);
        g.fill(shape);
        g.setStroke(this.beadStroke);
        g.setPaint(this.beadOutline);
        g.draw(shape);
    }

    public double getDepth(SequenceRenderContext context) {
        double maxDepth = super.getDepth(context);
        return Math.max(maxDepth, this.beadDepth + this.beadDisplacement);
    }

    public double getDimensionRatio() {
        return this.dimensionRatio;
    }

    public void setDimensionRatio(double ratio) throws ChangeVetoException {
        if (ratio < 1.0) {
            throw new ChangeVetoException("The long dimension may not be less than the short dimension (ratio >= 1.0)");
        }
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, RATIO, new Double(this.dimensionRatio), new Double(ratio)));
                cs.firePreChangeEvent(ce);
                this.dimensionRatio = ratio;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.dimensionRatio = ratio;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

