/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.biojava.bio.gui.sequence.AbstractBeadRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.Location;

public class RectangularBeadRenderer
extends AbstractBeadRenderer
implements FeatureRenderer {
    static /* synthetic */ Class class$javax$swing$JComponent;

    public RectangularBeadRenderer(double beadDepth, double beadDisplacement, Paint beadOutline, Paint beadFill, Stroke beadStroke) {
        super(beadDepth, beadDisplacement, beadOutline, beadFill, beadStroke);
    }

    protected void renderBead(Graphics2D g, Feature f, SequenceRenderContext context) {
        Rectangle2D.Double shape;
        Location loc = f.getLocation();
        int min = loc.getMin();
        int max = loc.getMax();
        int dif = max - min;
        if (context.getDirection() == 0) {
            double posXW = context.sequenceToGraphics(min);
            double posYN = this.beadDisplacement;
            double width = Math.max((double)(dif + 1) * context.getScale(), 1.0);
            double height = Math.min(this.beadDepth, width / 2.0);
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = RectangularBeadRenderer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(context)) {
                Rectangle visible = ((JComponent)((Object)context)).getVisibleRect();
                AffineTransform t = g.getTransform();
                t.translate(visible.getX(), visible.getY());
                try {
                    if (!t.createInverse().createTransformedShape(visible).intersects(posXW, posYN, width, height)) {
                        return;
                    }
                }
                catch (NoninvertibleTransformException ni) {
                    ni.printStackTrace();
                }
            }
            if (height < this.beadDepth) {
                posYN += (this.beadDepth - height) / 2.0;
            }
            shape = new Rectangle2D.Double(posXW, posYN, width, height);
        } else {
            double posXW = this.beadDisplacement;
            double posYN = context.sequenceToGraphics(min);
            double height = Math.max(((double)dif + 1.0) * context.getScale(), 1.0);
            double width = Math.min(this.beadDepth, height / 2.0);
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = RectangularBeadRenderer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(context)) {
                Rectangle visible = ((JComponent)((Object)context)).getVisibleRect();
                AffineTransform t = g.getTransform();
                t.translate(visible.getX(), visible.getY());
                try {
                    if (!t.createInverse().createTransformedShape(visible).intersects(posXW, posYN, width, height)) {
                        return;
                    }
                }
                catch (NoninvertibleTransformException ni) {
                    ni.printStackTrace();
                }
            }
            if (width < this.beadDepth) {
                posXW += (this.beadDepth - width) / 2.0;
            }
            shape = new Rectangle2D.Double(posXW, posYN, width, height);
        }
        g.setPaint(this.beadFill);
        g.fill(shape);
        g.setStroke(this.beadStroke);
        g.setPaint(this.beadOutline);
        g.draw(shape);
    }

    public double getDepth(SequenceRenderContext context) {
        double maxDepth = super.getDepth(context);
        return Math.max(maxDepth, this.beadDepth + this.beadDisplacement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

