/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class DASCapabilities {
    private static Map capabilityCache;
    public static final String CAPABILITY_FEATURETABLE = "featureTable";
    public static final String CAPABILITY_FEATURETABLE_DASGFF = "dasgff";
    public static final String CAPABILITY_FEATURETABLE_XFF = "xff";
    public static final String CAPABILITY_EXTENDED = "dasExtendedRequest";
    public static final String CAPABILITY_EXTENDED_FEATURES = "features";
    public static final String CAPABILITY_INDEX = "index";
    private static final Map DEFAULT_CAPABILITIES;

    DASCapabilities() {
    }

    public static boolean checkCapable(URL dasURL, String type) {
        return DASCapabilities.getCapabilities(dasURL).containsKey(type);
    }

    public static boolean checkCapable(URL dasURL, String type, String value) {
        List l = (List)DASCapabilities.getCapabilities(dasURL).get(type);
        if (l == null) {
            return false;
        }
        return l.contains(value);
    }

    public static Map getCapabilities(URL dasURL) {
        Map caps = (Map)capabilityCache.get(dasURL);
        if (caps == null) {
            caps = DASCapabilities.fetchCapabilities(dasURL);
            capabilityCache.put(dasURL, caps);
        }
        return caps;
    }

    private static Map fetchCapabilities(URL dasURL) {
        try {
            URL capURL = new URL(dasURL, "capabilities");
            HttpURLConnection huc = (HttpURLConnection)capURL.openConnection();
            huc.connect();
            int status = huc.getHeaderFieldInt("X-DAS-Status", 0);
            if (status == 0) {
                throw new BioException("Not a DAS server");
            }
            if (status != 200) {
                throw new BioException("DAS error (status code = " + status + ") connecting to " + dasURL);
            }
            InputSource is = new InputSource(huc.getInputStream());
            DocumentBuilder parser = DASSequence.nonvalidatingParser();
            Element el = parser.parse(is).getDocumentElement();
            HashMap caps = new HashMap();
            Node n = el.getFirstChild();
            while (n != null) {
                Element capEl;
                if (n instanceof Element && (capEl = (Element)n).getTagName().equals("capability")) {
                    String type = capEl.getAttribute("type");
                    String value = capEl.getAttribute("value");
                    if (caps.containsKey(type)) {
                        ((List)caps.get(type)).add(value);
                    } else {
                        ArrayList<String> l = new ArrayList<String>();
                        l.add(value);
                        caps.put(type, l);
                    }
                }
                n = n.getNextSibling();
            }
            return Collections.unmodifiableMap(caps);
        }
        catch (Exception ex) {
            return DEFAULT_CAPABILITIES;
        }
    }

    static {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        m.put(CAPABILITY_FEATURETABLE, Collections.nCopies(1, CAPABILITY_FEATURETABLE_DASGFF));
        DEFAULT_CAPABILITIES = Collections.unmodifiableMap(m);
        capabilityCache = new HashMap();
    }
}

