/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import org.biojava.bio.program.ssbind.SSPropHandlerFactory;
import org.biojava.bio.program.ssbind.SeqSimilarityAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class AlignmentHandler
extends DefaultHandler {
    public static final SSPropHandlerFactory ALIGNMENT_HANDLER_FACTORY = new SSPropHandlerFactory(){

        public ContentHandler getHandler(SeqSimilarityAdapter context) {
            return new AlignmentHandler(context);
        }
    };
    private SeqSimilarityAdapter context;
    private StringBuffer data;
    private String seqType;
    private String startPos;
    private String endPos;
    private int level = 0;

    AlignmentHandler(SeqSimilarityAdapter context) {
        this.context = context;
        this.data = new StringBuffer();
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        ++this.level;
        if (this.level > 1) {
            throw new SAXException("Found child element when expecting character data");
        }
        this.seqType = localName;
        this.startPos = attr.getValue("startPosition");
        this.endPos = attr.getValue("stopPosition");
    }

    public void endElement(String nsURI, String localName, String qName) throws SAXException {
        --this.level;
        if (this.level == 0) {
            this.setStringValue(this.data.toString());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.data.append(ch, start, length);
    }

    private void setStringValue(String s) throws SAXException {
        if (this.seqType.equals("QuerySequence")) {
            this.context.scHandler.addSubHitProperty("querySequence", s);
            this.context.scHandler.addSubHitProperty("querySequenceStart", this.startPos);
            this.context.scHandler.addSubHitProperty("querySequenceEnd", this.endPos);
        } else if (this.seqType.equals("HitSequence")) {
            this.context.scHandler.addSubHitProperty("subjectSequence", s);
            this.context.scHandler.addSubHitProperty("subjectSequenceStart", this.startPos);
            this.context.scHandler.addSubHitProperty("subjectSequenceEnd", this.endPos);
        }
    }
}

