/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SimpleSeqSimilaritySearchHit
implements SeqSimilaritySearchHit,
Cloneable {
    private double score;
    private double pValue;
    private double eValue;
    private int qStart;
    private int qEnd;
    private StrandedFeature.Strand qStrand;
    private int sStart;
    private int sEnd;
    private StrandedFeature.Strand sStrand;
    private String sequenceID;
    private List subHits;

    public SimpleSeqSimilaritySearchHit(double score, double eValue, double pValue, int qStart, int qEnd, StrandedFeature.Strand qStrand, int sStart, int sEnd, StrandedFeature.Strand sStrand, String sequenceID, List subHits) {
        Contract.pre(!Double.isNaN(score), "score was NaN");
        Contract.pre(qStrand != null, "query strand was null");
        Contract.pre(sStrand != null, "subject strand was null");
        Contract.pre(sequenceID != null, "sequenceID was null");
        Contract.pre(subHits != null, "subHits was null");
        this.score = score;
        this.pValue = pValue;
        this.eValue = eValue;
        this.sequenceID = sequenceID;
        this.qStart = qStart;
        this.qEnd = qEnd;
        this.qStrand = qStrand;
        this.sStart = sStart;
        this.sEnd = sEnd;
        this.sStrand = sStrand;
        this.subHits = subHits;
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.qStart;
    }

    public int getQueryEnd() {
        return this.qEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.qStrand;
    }

    public int getSubjectStart() {
        return this.sStart;
    }

    public int getSubjectEnd() {
        return this.sEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.sStrand;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public List getSubHits() {
        return Collections.unmodifiableList(this.subHits);
    }

    public String toString() {
        return "SequenceDBSearchHit to " + this.getSequenceID() + " with score " + this.getScore();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchHit that = (SimpleSeqSimilaritySearchHit)o;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceID, that.sequenceID)) {
            return false;
        }
        return ObjectUtil.equals(this.subHits, that.subHits);
    }

    public int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.score);
        hc = ObjectUtil.hashCode(hc, this.pValue);
        hc = ObjectUtil.hashCode(hc, this.eValue);
        hc = ObjectUtil.hashCode(hc, this.sequenceID);
        hc = ObjectUtil.hashCode(hc, this.subHits);
        return hc;
    }

    public Object clone() {
        return this;
    }
}

