/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;

public interface Feature
extends FeatureHolder,
Annotatable {
    public static final String PROPERTY_DATA_KEY = "internal_data";
    public static final ByLocationComparator byLocationOrder = new ByLocationComparator();
    public static final ByEmblOrderComparator byEmblOrder = new ByEmblOrderComparator();

    public Location getLocation();

    public String getType();

    public String getSource();

    public SymbolList getSymbols();

    public FeatureHolder getParent();

    public Sequence getSequence();

    public Iterator features();

    public Template makeTemplate();

    public static final class ByEmblOrderComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            boolean source2;
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            boolean source1 = f1.getType().equals("source");
            boolean bl = source2 = f2.getType().equals("source");
            if (!source1 && source2) {
                return 1;
            }
            if (source1 && !source2) {
                return -1;
            }
            if (f1.getLocation().getMin() > f2.getLocation().getMin()) {
                return 1;
            }
            if (f1.getLocation().getMin() < f2.getLocation().getMin()) {
                return -1;
            }
            return 0;
        }
    }

    public static final class ByLocationComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            if (f1.getLocation().getMin() > f2.getLocation().getMin()) {
                return 1;
            }
            if (f1.getLocation().getMin() < f2.getLocation().getMin()) {
                return -1;
            }
            return 0;
        }
    }

    public static class Template
    implements Serializable {
        public Location location;
        public String type;
        public String source;
        public Annotation annotation;
    }
}

